package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  ServiceId,
  TagMapKeyString,
  AccountId,
  Timestamp,
  ResourceArn,
  TagMapValueString,
  RouteId,
  ApplicationId
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateRouteResponse(
    applicationId: Option[ApplicationId] = None,
    arn: Option[ResourceArn] = None,
    createdByAccountId: Option[AccountId] = None,
    createdTime: Option[Timestamp] = None,
    lastUpdatedTime: Option[Timestamp] = None,
    ownerAccountId: Option[AccountId] = None,
    routeId: Option[RouteId] = None,
    routeType: Option[zio.aws.migrationhubrefactorspaces.model.RouteType] =
      None,
    serviceId: Option[ServiceId] = None,
    state: Option[zio.aws.migrationhubrefactorspaces.model.RouteState] = None,
    tags: Option[Map[TagMapKeyString, TagMapValueString]] = None,
    uriPathRoute: Option[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse = {
    import CreateRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdByAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.createdByAccountId)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        ownerAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.ownerAccountId)
      .optionallyWith(
        routeId.map(value => RouteId.unwrap(value): java.lang.String)
      )(_.routeId)
      .optionallyWith(routeType.map(value => value.unwrap))(_.routeType)
      .optionallyWith(
        serviceId.map(value => ServiceId.unwrap(value): java.lang.String)
      )(_.serviceId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagMapKeyString
                .unwrap(key): java.lang.String) -> (TagMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(uriPathRoute.map(value => value.buildAwsValue()))(
        _.uriPathRoute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse
      .wrap(buildAwsValue())
}
object CreateRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse =
      zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse(
        applicationId.map(value => value),
        arn.map(value => value),
        createdByAccountId.map(value => value),
        createdTime.map(value => value),
        lastUpdatedTime.map(value => value),
        ownerAccountId.map(value => value),
        routeId.map(value => value),
        routeType.map(value => value),
        serviceId.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        uriPathRoute.map(value => value.asEditable)
      )
    def applicationId: Option[ApplicationId]
    def arn: Option[ResourceArn]
    def createdByAccountId: Option[AccountId]
    def createdTime: Option[Timestamp]
    def lastUpdatedTime: Option[Timestamp]
    def ownerAccountId: Option[AccountId]
    def routeId: Option[RouteId]
    def routeType: Option[zio.aws.migrationhubrefactorspaces.model.RouteType]
    def serviceId: Option[ServiceId]
    def state: Option[zio.aws.migrationhubrefactorspaces.model.RouteState]
    def tags: Option[Map[TagMapKeyString, TagMapValueString]]
    def uriPathRoute: Option[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedByAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("createdByAccountId", createdByAccountId)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getOwnerAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getRouteId: ZIO[Any, AwsError, RouteId] =
      AwsError.unwrapOptionField("routeId", routeId)
    def getRouteType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteType
    ] = AwsError.unwrapOptionField("routeType", routeType)
    def getServiceId: ZIO[Any, AwsError, ServiceId] =
      AwsError.unwrapOptionField("serviceId", serviceId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.RouteState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagMapKeyString, TagMapValueString]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUriPathRoute: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ] = AwsError.unwrapOptionField("uriPathRoute", uriPathRoute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse
  ) extends zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly {
    override val applicationId: Option[ApplicationId] = scala
      .Option(impl.applicationId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApplicationId(value)
      )
    override val arn: Option[ResourceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ResourceArn(value)
      )
    override val createdByAccountId: Option[AccountId] = scala
      .Option(impl.createdByAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val createdTime: Option[Timestamp] = scala
      .Option(impl.createdTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val lastUpdatedTime: Option[Timestamp] = scala
      .Option(impl.lastUpdatedTime())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Timestamp(value)
      )
    override val ownerAccountId: Option[AccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.AccountId(value)
      )
    override val routeId: Option[RouteId] = scala
      .Option(impl.routeId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.RouteId(value)
      )
    override val routeType
        : Option[zio.aws.migrationhubrefactorspaces.model.RouteType] = scala
      .Option(impl.routeType())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.RouteType.wrap(value)
      )
    override val serviceId: Option[ServiceId] = scala
      .Option(impl.serviceId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ServiceId(value)
      )
    override val state
        : Option[zio.aws.migrationhubrefactorspaces.model.RouteState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.RouteState.wrap(value)
      )
    override val tags: Option[Map[TagMapKeyString, TagMapValueString]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhubrefactorspaces.model.primitives.TagMapKeyString(
              key
            ) -> zio.aws.migrationhubrefactorspaces.model.primitives
              .TagMapValueString(value)
          })
          .toMap
      )
    override val uriPathRoute: Option[
      zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.ReadOnly
    ] = scala
      .Option(impl.uriPathRoute())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.UriPathRouteInput.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.CreateRouteResponse
  ): zio.aws.migrationhubrefactorspaces.model.CreateRouteResponse.ReadOnly =
    new Wrapper(impl)
}
