package zio.aws.migrationhubrefactorspaces.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhubrefactorspaces.model.primitives.{
  Uri,
  NlbArn,
  NlbName,
  VpcLinkId,
  ApiGatewayId,
  StageName
}
import scala.jdk.CollectionConverters._
final case class ApiGatewayProxySummary(
    apiGatewayId: Option[ApiGatewayId] = None,
    endpointType: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = None,
    nlbArn: Option[NlbArn] = None,
    nlbName: Option[NlbName] = None,
    proxyUrl: Option[Uri] = None,
    stageName: Option[StageName] = None,
    vpcLinkId: Option[VpcLinkId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxySummary = {
    import ApiGatewayProxySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxySummary
      .builder()
      .optionallyWith(
        apiGatewayId.map(value => ApiGatewayId.unwrap(value): java.lang.String)
      )(_.apiGatewayId)
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        nlbArn.map(value => NlbArn.unwrap(value): java.lang.String)
      )(_.nlbArn)
      .optionallyWith(
        nlbName.map(value => NlbName.unwrap(value): java.lang.String)
      )(_.nlbName)
      .optionallyWith(
        proxyUrl.map(value => Uri.unwrap(value): java.lang.String)
      )(_.proxyUrl)
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(
        vpcLinkId.map(value => VpcLinkId.unwrap(value): java.lang.String)
      )(_.vpcLinkId)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly =
    zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary
      .wrap(buildAwsValue())
}
object ApiGatewayProxySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary =
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary(
        apiGatewayId.map(value => value),
        endpointType.map(value => value),
        nlbArn.map(value => value),
        nlbName.map(value => value),
        proxyUrl.map(value => value),
        stageName.map(value => value),
        vpcLinkId.map(value => value)
      )
    def apiGatewayId: Option[ApiGatewayId]
    def endpointType: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ]
    def nlbArn: Option[NlbArn]
    def nlbName: Option[NlbName]
    def proxyUrl: Option[Uri]
    def stageName: Option[StageName]
    def vpcLinkId: Option[VpcLinkId]
    def getApiGatewayId: ZIO[Any, AwsError, ApiGatewayId] =
      AwsError.unwrapOptionField("apiGatewayId", apiGatewayId)
    def getEndpointType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = AwsError.unwrapOptionField("endpointType", endpointType)
    def getNlbArn: ZIO[Any, AwsError, NlbArn] =
      AwsError.unwrapOptionField("nlbArn", nlbArn)
    def getNlbName: ZIO[Any, AwsError, NlbName] =
      AwsError.unwrapOptionField("nlbName", nlbName)
    def getProxyUrl: ZIO[Any, AwsError, Uri] =
      AwsError.unwrapOptionField("proxyUrl", proxyUrl)
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getVpcLinkId: ZIO[Any, AwsError, VpcLinkId] =
      AwsError.unwrapOptionField("vpcLinkId", vpcLinkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxySummary
  ) extends zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly {
    override val apiGatewayId: Option[ApiGatewayId] = scala
      .Option(impl.apiGatewayId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.ApiGatewayId(value)
      )
    override val endpointType: Option[
      zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
    ] = scala
      .Option(impl.endpointType())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.ApiGatewayEndpointType
          .wrap(value)
      )
    override val nlbArn: Option[NlbArn] = scala
      .Option(impl.nlbArn())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NlbArn(value)
      )
    override val nlbName: Option[NlbName] = scala
      .Option(impl.nlbName())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.NlbName(value)
      )
    override val proxyUrl: Option[Uri] = scala
      .Option(impl.proxyUrl())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.Uri(value)
      )
    override val stageName: Option[StageName] = scala
      .Option(impl.stageName())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.StageName(value)
      )
    override val vpcLinkId: Option[VpcLinkId] = scala
      .Option(impl.vpcLinkId())
      .map(value =>
        zio.aws.migrationhubrefactorspaces.model.primitives.VpcLinkId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhubrefactorspaces.model.ApiGatewayProxySummary
  ): zio.aws.migrationhubrefactorspaces.model.ApiGatewayProxySummary.ReadOnly =
    new Wrapper(impl)
}
