package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  Integer,
  StringListMember
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowStepSummary(
    stepId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    stepActionType: Optional[
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = Optional.Absent,
    owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.StepStatus] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    noOfSrvCompleted: Optional[Integer] = Optional.Absent,
    noOfSrvFailed: Optional[Integer] = Optional.Absent,
    totalNoOfSrv: Optional[Integer] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    scriptLocation: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepSummary = {
    import WorkflowStepSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepSummary
      .builder()
      .optionallyWith(stepId.map(value => value: java.lang.String))(_.stepId)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(stepActionType.map(value => value.unwrap))(
        _.stepActionType
      )
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(noOfSrvCompleted.map(value => value: java.lang.Integer))(
        _.noOfSrvCompleted
      )
      .optionallyWith(noOfSrvFailed.map(value => value: java.lang.Integer))(
        _.noOfSrvFailed
      )
      .optionallyWith(totalNoOfSrv.map(value => value: java.lang.Integer))(
        _.totalNoOfSrv
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(scriptLocation.map(value => value: java.lang.String))(
        _.scriptLocation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly =
    zio.aws.migrationhuborchestrator.model.WorkflowStepSummary
      .wrap(buildAwsValue())
}
object WorkflowStepSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.WorkflowStepSummary =
      zio.aws.migrationhuborchestrator.model.WorkflowStepSummary(
        stepId.map(value => value),
        name.map(value => value),
        stepActionType.map(value => value),
        owner.map(value => value),
        previous.map(value => value),
        next.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        noOfSrvCompleted.map(value => value),
        noOfSrvFailed.map(value => value),
        totalNoOfSrv.map(value => value),
        description.map(value => value),
        scriptLocation.map(value => value)
      )
    def stepId: Optional[String]
    def name: Optional[String]
    def stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType]
    def owner: Optional[zio.aws.migrationhuborchestrator.model.Owner]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def status: Optional[zio.aws.migrationhuborchestrator.model.StepStatus]
    def statusMessage: Optional[String]
    def noOfSrvCompleted: Optional[Integer]
    def noOfSrvFailed: Optional[Integer]
    def totalNoOfSrv: Optional[Integer]
    def description: Optional[String]
    def scriptLocation: Optional[String]
    def getStepId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepId", stepId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStepActionType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = AwsError.unwrapOptionField("stepActionType", stepActionType)
    def getOwner
        : ZIO[Any, AwsError, zio.aws.migrationhuborchestrator.model.Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getNoOfSrvCompleted: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("noOfSrvCompleted", noOfSrvCompleted)
    def getNoOfSrvFailed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("noOfSrvFailed", noOfSrvFailed)
    def getTotalNoOfSrv: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalNoOfSrv", totalNoOfSrv)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getScriptLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scriptLocation", scriptLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepSummary
  ) extends zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly {
    override val stepId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepActionType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepActionType.wrap(value)
        )
    override val owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.migrationhuborchestrator.model.Owner.wrap(value))
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.StepStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepStatus.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val noOfSrvCompleted: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.noOfSrvCompleted())
      .map(value => value: Integer)
    override val noOfSrvFailed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.noOfSrvFailed())
      .map(value => value: Integer)
    override val totalNoOfSrv: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalNoOfSrv())
      .map(value => value: Integer)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val scriptLocation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptLocation())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepSummary
  ): zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly =
    new Wrapper(impl)
}
