package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  MigrationWorkflowId,
  StepId,
  StepName,
  StepGroupId,
  StepDescription
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateWorkflowStepRequest(
    id: StepId,
    stepGroupId: StepGroupId,
    workflowId: MigrationWorkflowId,
    name: Optional[StepName] = Optional.Absent,
    description: Optional[StepDescription] = Optional.Absent,
    stepActionType: Optional[
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = Optional.Absent,
    workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration
    ] = Optional.Absent,
    stepTarget: Optional[Iterable[StringListMember]] = Optional.Absent,
    outputs: Optional[
      Iterable[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput]
    ] = Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.StepStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest = {
    import UpdateWorkflowStepRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest
      .builder()
      .id(StepId.unwrap(id): java.lang.String)
      .stepGroupId(StepGroupId.unwrap(stepGroupId): java.lang.String)
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .optionallyWith(
        name.map(value => StepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          StepDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(stepActionType.map(value => value.unwrap))(
        _.stepActionType
      )
      .optionallyWith(
        workflowStepAutomationConfiguration.map(value => value.buildAwsValue())
      )(_.workflowStepAutomationConfiguration)
      .optionallyWith(
        stepTarget.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stepTarget)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepRequest
      .wrap(buildAwsValue())
}
object UpdateWorkflowStepRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepRequest =
      zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepRequest(
        id,
        stepGroupId,
        workflowId,
        name.map(value => value),
        description.map(value => value),
        stepActionType.map(value => value),
        workflowStepAutomationConfiguration.map(value => value.asEditable),
        stepTarget.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        previous.map(value => value),
        next.map(value => value),
        status.map(value => value)
      )
    def id: StepId
    def stepGroupId: StepGroupId
    def workflowId: MigrationWorkflowId
    def name: Optional[StepName]
    def description: Optional[StepDescription]
    def stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType]
    def workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ]
    def stepTarget: Optional[List[StringListMember]]
    def outputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly]
    ]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def status: Optional[zio.aws.migrationhuborchestrator.model.StepStatus]
    def getId: ZIO[Any, Nothing, StepId] = ZIO.succeed(id)
    def getStepGroupId: ZIO[Any, Nothing, StepGroupId] =
      ZIO.succeed(stepGroupId)
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
    def getName: ZIO[Any, AwsError, StepName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, StepDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStepActionType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = AwsError.unwrapOptionField("stepActionType", stepActionType)
    def getWorkflowStepAutomationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowStepAutomationConfiguration",
      workflowStepAutomationConfiguration
    )
    def getStepTarget: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("stepTarget", stepTarget)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest
  ) extends zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepRequest.ReadOnly {
    override val id: StepId =
      zio.aws.migrationhuborchestrator.model.primitives.StepId(impl.id())
    override val stepGroupId: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives
        .StepGroupId(impl.stepGroupId())
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
    override val name: Optional[StepName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.StepName(value)
      )
    override val description: Optional[StepDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.StepDescription(value)
      )
    override val stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepActionType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepActionType.wrap(value)
        )
    override val workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowStepAutomationConfiguration())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration
          .wrap(value)
      )
    override val stepTarget: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepTarget())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val outputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.wrap(item)
        }.toList
      )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.StepStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest
  ): zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepRequest.ReadOnly =
    new Wrapper(impl)
}
