package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.MigrationWorkflowId
import scala.jdk.CollectionConverters.*
final case class StartWorkflowRequest(id: MigrationWorkflowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.StartWorkflowRequest = {
    import StartWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.StartWorkflowRequest
      .builder()
      .id(MigrationWorkflowId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.StartWorkflowRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.StartWorkflowRequest
      .wrap(buildAwsValue())
}
object StartWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.StartWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.StartWorkflowRequest =
      zio.aws.migrationhuborchestrator.model.StartWorkflowRequest(id)
    def id: MigrationWorkflowId
    def getId: ZIO[Any, Nothing, MigrationWorkflowId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StartWorkflowRequest
  ) extends zio.aws.migrationhuborchestrator.model.StartWorkflowRequest.ReadOnly {
    override val id: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StartWorkflowRequest
  ): zio.aws.migrationhuborchestrator.model.StartWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
