package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.{
  StepGroupId,
  TemplateId,
  StepId
}
import scala.jdk.CollectionConverters.*
final case class GetTemplateStepRequest(
    id: StepId,
    templateId: TemplateId,
    stepGroupId: StepGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepRequest = {
    import GetTemplateStepRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepRequest
      .builder()
      .id(StepId.unwrap(id): java.lang.String)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .stepGroupId(StepGroupId.unwrap(stepGroupId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetTemplateStepRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetTemplateStepRequest
      .wrap(buildAwsValue())
}
object GetTemplateStepRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.GetTemplateStepRequest =
      zio.aws.migrationhuborchestrator.model
        .GetTemplateStepRequest(id, templateId, stepGroupId)
    def id: StepId
    def templateId: TemplateId
    def stepGroupId: StepGroupId
    def getId: ZIO[Any, Nothing, StepId] = ZIO.succeed(id)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
    def getStepGroupId: ZIO[Any, Nothing, StepGroupId] =
      ZIO.succeed(stepGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepRequest
  ) extends zio.aws.migrationhuborchestrator.model.GetTemplateStepRequest.ReadOnly {
    override val id: StepId =
      zio.aws.migrationhuborchestrator.model.primitives.StepId(impl.id())
    override val templateId: TemplateId =
      zio.aws.migrationhuborchestrator.model.primitives
        .TemplateId(impl.templateId())
    override val stepGroupId: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives
        .StepGroupId(impl.stepGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepRequest
  ): zio.aws.migrationhuborchestrator.model.GetTemplateStepRequest.ReadOnly =
    new Wrapper(impl)
}
