package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Tool(
    name: Optional[String] = Optional.Absent,
    url: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.Tool = {
    import Tool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.Tool
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.migrationhuborchestrator.model.Tool.ReadOnly =
    zio.aws.migrationhuborchestrator.model.Tool.wrap(buildAwsValue())
}
object Tool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.Tool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.Tool =
      zio.aws.migrationhuborchestrator.model
        .Tool(name.map(value => value), url.map(value => value))
    def name: Optional[String]
    def url: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.Tool
  ) extends zio.aws.migrationhuborchestrator.model.Tool.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val url: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.Tool
  ): zio.aws.migrationhuborchestrator.model.Tool.ReadOnly = new Wrapper(impl)
}
