package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PlatformCommand(
    linux: Optional[String] = Optional.Absent,
    windows: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformCommand = {
    import PlatformCommand.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformCommand
      .builder()
      .optionallyWith(linux.map(value => value: java.lang.String))(_.linux)
      .optionallyWith(windows.map(value => value: java.lang.String))(_.windows)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.PlatformCommand.ReadOnly =
    zio.aws.migrationhuborchestrator.model.PlatformCommand.wrap(buildAwsValue())
}
object PlatformCommand {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformCommand
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.PlatformCommand =
      zio.aws.migrationhuborchestrator.model
        .PlatformCommand(linux.map(value => value), windows.map(value => value))
    def linux: Optional[String]
    def windows: Optional[String]
    def getLinux: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("linux", linux)
    def getWindows: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("windows", windows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformCommand
  ) extends zio.aws.migrationhuborchestrator.model.PlatformCommand.ReadOnly {
    override val linux: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.linux())
      .map(value => value: String)
    override val windows: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.windows())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformCommand
  ): zio.aws.migrationhuborchestrator.model.PlatformCommand.ReadOnly =
    new Wrapper(impl)
}
