package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.{
  StepGroupId,
  TemplateId
}
import scala.jdk.CollectionConverters.*
final case class GetTemplateStepGroupRequest(
    templateId: TemplateId,
    id: StepGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest = {
    import GetTemplateStepGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest
      .builder()
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .id(StepGroupId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupRequest
      .wrap(buildAwsValue())
}
object GetTemplateStepGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupRequest =
      zio.aws.migrationhuborchestrator.model
        .GetTemplateStepGroupRequest(templateId, id)
    def templateId: TemplateId
    def id: StepGroupId
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
    def getId: ZIO[Any, Nothing, StepGroupId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest
  ) extends zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupRequest.ReadOnly {
    override val templateId: TemplateId =
      zio.aws.migrationhuborchestrator.model.primitives
        .TemplateId(impl.templateId())
    override val id: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives.StepGroupId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest
  ): zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupRequest.ReadOnly =
    new Wrapper(impl)
}
