package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  StepInputParametersKey,
  CreateMigrationWorkflowRequestDescriptionString,
  StringMapValue,
  CreateMigrationWorkflowRequestNameString,
  StringMapKey,
  CreateMigrationWorkflowRequestTemplateIdString,
  CreateMigrationWorkflowRequestApplicationConfigurationIdString
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkflowRequest(
    name: CreateMigrationWorkflowRequestNameString,
    description: Optional[CreateMigrationWorkflowRequestDescriptionString] =
      Optional.Absent,
    templateId: CreateMigrationWorkflowRequestTemplateIdString,
    applicationConfigurationId: CreateMigrationWorkflowRequestApplicationConfigurationIdString,
    inputParameters: Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput
    ],
    stepTargets: Optional[Iterable[StringListMember]] = Optional.Absent,
    tags: Optional[Map[StringMapKey, StringMapValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowRequest = {
    import CreateWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowRequest
      .builder()
      .name(
        CreateMigrationWorkflowRequestNameString.unwrap(name): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          CreateMigrationWorkflowRequestDescriptionString.unwrap(
            value
          ): java.lang.String
        )
      )(_.description)
      .templateId(
        CreateMigrationWorkflowRequestTemplateIdString.unwrap(
          templateId
        ): java.lang.String
      )
      .applicationConfigurationId(
        CreateMigrationWorkflowRequestApplicationConfigurationIdString.unwrap(
          applicationConfigurationId
        ): java.lang.String
      )
      .inputParameters(
        inputParameters
          .map({ case (key, value) =>
            (StepInputParametersKey.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(
        stepTargets.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stepTargets)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.CreateWorkflowRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.CreateWorkflowRequest
      .wrap(buildAwsValue())
}
object CreateWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.CreateWorkflowRequest =
      zio.aws.migrationhuborchestrator.model.CreateWorkflowRequest(
        name,
        description.map(value => value),
        templateId,
        applicationConfigurationId,
        inputParameters.map({ case (key, value) =>
          key -> value.asEditable
        }),
        stepTargets.map(value => value),
        tags.map(value => value)
      )
    def name: CreateMigrationWorkflowRequestNameString
    def description: Optional[CreateMigrationWorkflowRequestDescriptionString]
    def templateId: CreateMigrationWorkflowRequestTemplateIdString
    def applicationConfigurationId
        : CreateMigrationWorkflowRequestApplicationConfigurationIdString
    def inputParameters: Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]
    def stepTargets: Optional[List[StringListMember]]
    def tags: Optional[Map[StringMapKey, StringMapValue]]
    def getName: ZIO[Any, Nothing, CreateMigrationWorkflowRequestNameString] =
      ZIO.succeed(name)
    def getDescription
        : ZIO[Any, AwsError, CreateMigrationWorkflowRequestDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateId
        : ZIO[Any, Nothing, CreateMigrationWorkflowRequestTemplateIdString] =
      ZIO.succeed(templateId)
    def getApplicationConfigurationId: ZIO[
      Any,
      Nothing,
      CreateMigrationWorkflowRequestApplicationConfigurationIdString
    ] = ZIO.succeed(applicationConfigurationId)
    def getInputParameters: ZIO[Any, Nothing, Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]] = ZIO.succeed(inputParameters)
    def getStepTargets: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("stepTargets", stepTargets)
    def getTags: ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowRequest
  ) extends zio.aws.migrationhuborchestrator.model.CreateWorkflowRequest.ReadOnly {
    override val name: CreateMigrationWorkflowRequestNameString =
      zio.aws.migrationhuborchestrator.model.primitives
        .CreateMigrationWorkflowRequestNameString(impl.name())
    override val description
        : Optional[CreateMigrationWorkflowRequestDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.primitives
            .CreateMigrationWorkflowRequestDescriptionString(value)
        )
    override val templateId: CreateMigrationWorkflowRequestTemplateIdString =
      zio.aws.migrationhuborchestrator.model.primitives
        .CreateMigrationWorkflowRequestTemplateIdString(impl.templateId())
    override val applicationConfigurationId
        : CreateMigrationWorkflowRequestApplicationConfigurationIdString =
      zio.aws.migrationhuborchestrator.model.primitives
        .CreateMigrationWorkflowRequestApplicationConfigurationIdString(
          impl.applicationConfigurationId()
        )
    override val inputParameters: Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ] = impl
      .inputParameters()
      .asScala
      .map({ case (key, value) =>
        zio.aws.migrationhuborchestrator.model.primitives
          .StepInputParametersKey(
            key
          ) -> zio.aws.migrationhuborchestrator.model.StepInput.wrap(value)
      })
      .toMap
    override val stepTargets: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val tags: Optional[Map[StringMapKey, StringMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhuborchestrator.model.primitives.StringMapKey(
                key
              ) -> zio.aws.migrationhuborchestrator.model.primitives
                .StringMapValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowRequest
  ): zio.aws.migrationhuborchestrator.model.CreateWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
