package zio.aws.migrationhuborchestrator.model
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  MigrationWorkflowId,
  MaxResults,
  NextToken
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkflowStepGroupsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    workflowId: MigrationWorkflowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest = {
    import ListWorkflowStepGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
      .wrap(buildAwsValue())
}
object ListWorkflowStepGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest =
      zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        workflowId
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def workflowId: MigrationWorkflowId
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
  ) extends zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.MaxResults(value)
      )
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
  ): zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
