package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  Timestamp,
  StepGroupId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetWorkflowStepGroupResponse(
    id: Optional[StepGroupId] = Optional.Absent,
    workflowId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus] =
      Optional.Absent,
    owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    tools: Optional[Iterable[zio.aws.migrationhuborchestrator.model.Tool]] =
      Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupResponse = {
    import GetWorkflowStepGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupResponse
      .builder()
      .optionallyWith(
        id.map(value => StepGroupId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(workflowId.map(value => value: java.lang.String))(
        _.workflowId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        tools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tools)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse
      .wrap(buildAwsValue())
}
object GetWorkflowStepGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse =
      zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse(
        id.map(value => value),
        workflowId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        owner.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        endTime.map(value => value),
        tools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        previous.map(value => value),
        next.map(value => value)
      )
    def id: Optional[StepGroupId]
    def workflowId: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def status: Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus]
    def owner: Optional[zio.aws.migrationhuborchestrator.model.Owner]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def getId: ZIO[Any, AwsError, StepGroupId] =
      AwsError.unwrapOptionField("id", id)
    def getWorkflowId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepGroupStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getOwner
        : ZIO[Any, AwsError, zio.aws.migrationhuborchestrator.model.Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTools: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.Tool.ReadOnly
    ]] = AwsError.unwrapOptionField("tools", tools)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupResponse
  ) extends zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.ReadOnly {
    override val id: Optional[StepGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.StepGroupId(value)
      )
    override val workflowId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepGroupStatus.wrap(value)
        )
    override val owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.migrationhuborchestrator.model.Owner.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.Tool.wrap(item)
          }.toList
        )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupResponse
  ): zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.ReadOnly =
    new Wrapper(impl)
}
