package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetTemplateStepGroupResponse(
    templateId: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    tools: Optional[Iterable[zio.aws.migrationhuborchestrator.model.Tool]] =
      Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupResponse = {
    import GetTemplateStepGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupResponse
      .builder()
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        tools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tools)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse
      .wrap(buildAwsValue())
}
object GetTemplateStepGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse =
      zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse(
        templateId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        tools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        previous.map(value => value),
        next.map(value => value)
      )
    def templateId: Optional[String]
    def id: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def status: Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def getTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepGroupStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getTools: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.Tool.ReadOnly
    ]] = AwsError.unwrapOptionField("tools", tools)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupResponse
  ) extends zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.ReadOnly {
    override val templateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepGroupStatus.wrap(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.Tool.wrap(item)
          }.toList
        )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupResponse
  ): zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.ReadOnly =
    new Wrapper(impl)
}
