package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.MigrationWorkflowId
import scala.jdk.CollectionConverters.*
final case class DeleteWorkflowRequest(id: MigrationWorkflowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowRequest = {
    import DeleteWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowRequest
      .builder()
      .id(MigrationWorkflowId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.DeleteWorkflowRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowRequest
      .wrap(buildAwsValue())
}
object DeleteWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.DeleteWorkflowRequest =
      zio.aws.migrationhuborchestrator.model.DeleteWorkflowRequest(id)
    def id: MigrationWorkflowId
    def getId: ZIO[Any, Nothing, MigrationWorkflowId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowRequest
  ) extends zio.aws.migrationhuborchestrator.model.DeleteWorkflowRequest.ReadOnly {
    override val id: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowRequest
  ): zio.aws.migrationhuborchestrator.model.DeleteWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
