package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  StepGroupDescription,
  StepGroupName,
  MigrationWorkflowId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkflowStepGroupRequest(
    workflowId: MigrationWorkflowId,
    name: StepGroupName,
    description: Optional[StepGroupDescription] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest = {
    import CreateWorkflowStepGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest
      .builder()
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .name(StepGroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          StepGroupDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest
      .wrap(buildAwsValue())
}
object CreateWorkflowStepGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest =
      zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest(
        workflowId,
        name,
        description.map(value => value),
        next.map(value => value),
        previous.map(value => value)
      )
    def workflowId: MigrationWorkflowId
    def name: StepGroupName
    def description: Optional[StepGroupDescription]
    def next: Optional[List[StringListMember]]
    def previous: Optional[List[StringListMember]]
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
    def getName: ZIO[Any, Nothing, StepGroupName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, StepGroupDescription] =
      AwsError.unwrapOptionField("description", description)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest
  ) extends zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest.ReadOnly {
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
    override val name: StepGroupName =
      zio.aws.migrationhuborchestrator.model.primitives
        .StepGroupName(impl.name())
    override val description: Optional[StepGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StepGroupDescription(value)
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest
  ): zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest.ReadOnly =
    new Wrapper(impl)
}
