package zio.aws.migrationhuborchestrator
import zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.migrationhuborchestrator.model.{
  DeleteWorkflowStepRequest,
  CreateWorkflowStepRequest,
  CreateWorkflowRequest,
  UpdateWorkflowRequest,
  GetWorkflowStepRequest,
  DeleteWorkflowStepGroupRequest,
  UpdateWorkflowStepRequest,
  StartWorkflowRequest,
  ListWorkflowsRequest,
  RetryWorkflowStepRequest,
  GetWorkflowStepGroupRequest,
  ListTagsForResourceRequest,
  GetTemplateStepRequest,
  ListWorkflowStepsRequest,
  UpdateWorkflowStepGroupRequest,
  GetTemplateStepGroupRequest,
  ListWorkflowStepGroupsRequest,
  UntagResourceRequest,
  StopWorkflowRequest,
  CreateWorkflowStepGroupRequest,
  ListTemplateStepGroupsRequest,
  ListPluginsRequest,
  ListTemplatesRequest,
  GetTemplateRequest,
  DeleteWorkflowRequest,
  TagResourceRequest,
  ListTemplateStepsRequest,
  GetWorkflowRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.migrationhuborchestrator.MigrationHubOrchestratorAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object MigrationHubOrchestratorMock extends Mock[MigrationHubOrchestrator] {
  object GetWorkflowStep
      extends Effect[
        GetWorkflowStepRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.ReadOnly
      ]
  object ListWorkflowSteps
      extends Stream[
        ListWorkflowStepsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly
      ]
  object ListWorkflowStepsPaginated
      extends Effect[
        ListWorkflowStepsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.ReadOnly
      ]
  object GetWorkflowStepGroup
      extends Effect[
        GetWorkflowStepGroupRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.ReadOnly
      ]
  object UpdateWorkflowStep
      extends Effect[UpdateWorkflowStepRequest, AwsError, ReadOnly]
  object RetryWorkflowStep
      extends Effect[
        RetryWorkflowStepRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.ReadOnly
      ]
  object DeleteWorkflowStep
      extends Effect[
        DeleteWorkflowStepRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepResponse.ReadOnly
      ]
  object StartWorkflow
      extends Effect[
        StartWorkflowRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.StartWorkflowResponse.ReadOnly
      ]
  object StopWorkflow
      extends Effect[
        StopWorkflowRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.ReadOnly
      ]
  object UpdateWorkflowStepGroup
      extends Effect[
        UpdateWorkflowStepGroupRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.ReadOnly
      ]
  object ListTemplates
      extends Stream[
        ListTemplatesRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly
      ]
  object ListTemplatesPaginated
      extends Effect[
        ListTemplatesRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.ReadOnly
      ]
  object ListPlugins
      extends Stream[
        ListPluginsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly
      ]
  object ListPluginsPaginated
      extends Effect[
        ListPluginsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.ListPluginsResponse.ReadOnly
      ]
  object UpdateWorkflow
      extends Effect[
        UpdateWorkflowRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.UpdateWorkflowResponse.ReadOnly
      ]
  object CreateWorkflowStepGroup
      extends Effect[
        CreateWorkflowStepGroupRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.UntagResourceResponse.ReadOnly
      ]
  object GetWorkflow
      extends Effect[
        GetWorkflowRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.ReadOnly
      ]
  object GetTemplateStepGroup
      extends Effect[
        GetTemplateStepGroupRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.ReadOnly
      ]
  object ListTemplateStepGroups
      extends Stream[
        ListTemplateStepGroupsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly
      ]
  object ListTemplateStepGroupsPaginated
      extends Effect[
        ListTemplateStepGroupsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.TagResourceResponse.ReadOnly
      ]
  object ListWorkflows
      extends Stream[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly
      ]
  object ListWorkflowsPaginated
      extends Effect[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.ReadOnly
      ]
  object ListTemplateSteps
      extends Stream[
        ListTemplateStepsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly
      ]
  object ListTemplateStepsPaginated
      extends Effect[
        ListTemplateStepsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.ReadOnly
      ]
  object DeleteWorkflowStepGroup
      extends Effect[
        DeleteWorkflowStepGroupRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse.ReadOnly
      ]
  object DeleteWorkflow
      extends Effect[
        DeleteWorkflowRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.ReadOnly
      ]
  object ListWorkflowStepGroups
      extends Stream[
        ListWorkflowStepGroupsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly
      ]
  object ListWorkflowStepGroupsPaginated
      extends Effect[
        ListWorkflowStepGroupsRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.ReadOnly
      ]
  object CreateWorkflowStep
      extends Effect[
        CreateWorkflowStepRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.ReadOnly
      ]
  object GetTemplate
      extends Effect[
        GetTemplateRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.GetTemplateResponse.ReadOnly
      ]
  object GetTemplateStep
      extends Effect[
        GetTemplateStepRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.ReadOnly
      ]
  object CreateWorkflow
      extends Effect[
        CreateWorkflowRequest,
        AwsError,
        zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MigrationHubOrchestrator] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, MigrationHubOrchestrator] { rts =>
        zio.ZIO.succeed {
          new MigrationHubOrchestrator {
            val api: MigrationHubOrchestratorAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): MigrationHubOrchestrator = this
            def getWorkflowStep(request: GetWorkflowStepRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.ReadOnly
            ] = proxy(GetWorkflowStep, request)
            def listWorkflowSteps(request: ListWorkflowStepsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflowSteps, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowStepsPaginated(
                request: ListWorkflowStepsRequest
            ): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.ReadOnly
            ] = proxy(ListWorkflowStepsPaginated, request)
            def getWorkflowStepGroup(request: GetWorkflowStepGroupRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.ReadOnly
            ] = proxy(GetWorkflowStepGroup, request)
            def updateWorkflowStep(
                request: UpdateWorkflowStepRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateWorkflowStep, request)
            def retryWorkflowStep(request: RetryWorkflowStepRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.ReadOnly
            ] = proxy(RetryWorkflowStep, request)
            def deleteWorkflowStep(request: DeleteWorkflowStepRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepResponse.ReadOnly
            ] = proxy(DeleteWorkflowStep, request)
            def startWorkflow(request: StartWorkflowRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.StartWorkflowResponse.ReadOnly
            ] = proxy(StartWorkflow, request)
            def stopWorkflow(request: StopWorkflowRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.ReadOnly
            ] = proxy(StopWorkflow, request)
            def updateWorkflowStepGroup(
                request: UpdateWorkflowStepGroupRequest
            ): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.ReadOnly
            ] = proxy(UpdateWorkflowStepGroup, request)
            def listTemplates(request: ListTemplatesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTemplatesPaginated(request: ListTemplatesRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.ReadOnly
            ] = proxy(ListTemplatesPaginated, request)
            def listPlugins(request: ListPluginsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPlugins, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPluginsPaginated(request: ListPluginsRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.ListPluginsResponse.ReadOnly
            ] = proxy(ListPluginsPaginated, request)
            def updateWorkflow(request: UpdateWorkflowRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.UpdateWorkflowResponse.ReadOnly
            ] = proxy(UpdateWorkflow, request)
            def createWorkflowStepGroup(
                request: CreateWorkflowStepGroupRequest
            ): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse.ReadOnly
            ] = proxy(CreateWorkflowStepGroup, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getWorkflow(request: GetWorkflowRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.ReadOnly
            ] = proxy(GetWorkflow, request)
            def getTemplateStepGroup(request: GetTemplateStepGroupRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.ReadOnly
            ] = proxy(GetTemplateStepGroup, request)
            def listTemplateStepGroups(
                request: ListTemplateStepGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTemplateStepGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTemplateStepGroupsPaginated(
                request: ListTemplateStepGroupsRequest
            ): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.ReadOnly
            ] = proxy(ListTemplateStepGroupsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listWorkflows(request: ListWorkflowsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowsPaginated(request: ListWorkflowsRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.ReadOnly
            ] = proxy(ListWorkflowsPaginated, request)
            def listTemplateSteps(request: ListTemplateStepsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTemplateSteps, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTemplateStepsPaginated(
                request: ListTemplateStepsRequest
            ): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.ReadOnly
            ] = proxy(ListTemplateStepsPaginated, request)
            def deleteWorkflowStepGroup(
                request: DeleteWorkflowStepGroupRequest
            ): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse.ReadOnly
            ] = proxy(DeleteWorkflowStepGroup, request)
            def deleteWorkflow(request: DeleteWorkflowRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.ReadOnly
            ] = proxy(DeleteWorkflow, request)
            def listWorkflowStepGroups(
                request: ListWorkflowStepGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflowStepGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowStepGroupsPaginated(
                request: ListWorkflowStepGroupsRequest
            ): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.ReadOnly
            ] = proxy(ListWorkflowStepGroupsPaginated, request)
            def createWorkflowStep(request: CreateWorkflowStepRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.ReadOnly
            ] = proxy(CreateWorkflowStep, request)
            def getTemplate(request: GetTemplateRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.GetTemplateResponse.ReadOnly
            ] = proxy(GetTemplate, request)
            def getTemplateStep(request: GetTemplateStepRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.ReadOnly
            ] = proxy(GetTemplateStep, request)
            def createWorkflow(request: CreateWorkflowRequest): IO[
              AwsError,
              zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.ReadOnly
            ] = proxy(CreateWorkflow, request)
          }
        }
      }
    }
  }
}
