package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.TemplateInputName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateInput(
    inputName: Optional[TemplateInputName] = Optional.Absent,
    dataType: Optional[zio.aws.migrationhuborchestrator.model.DataType] =
      Optional.Absent,
    required: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput = {
    import TemplateInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput
      .builder()
      .optionallyWith(
        inputName.map(value =>
          TemplateInputName.unwrap(value): java.lang.String
        )
      )(_.inputName)
      .optionallyWith(dataType.map(value => value.unwrap))(_.dataType)
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.TemplateInput.ReadOnly =
    zio.aws.migrationhuborchestrator.model.TemplateInput.wrap(buildAwsValue())
}
object TemplateInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.TemplateInput =
      zio.aws.migrationhuborchestrator.model.TemplateInput(
        inputName.map(value => value),
        dataType.map(value => value),
        required.map(value => value)
      )
    def inputName: Optional[TemplateInputName]
    def dataType: Optional[zio.aws.migrationhuborchestrator.model.DataType]
    def required: Optional[Boolean]
    def getInputName: ZIO[Any, AwsError, TemplateInputName] =
      AwsError.unwrapOptionField("inputName", inputName)
    def getDataType
        : ZIO[Any, AwsError, zio.aws.migrationhuborchestrator.model.DataType] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput
  ) extends zio.aws.migrationhuborchestrator.model.TemplateInput.ReadOnly {
    override val inputName: Optional[TemplateInputName] = zio.aws.core.internal
      .optionalFromNullable(impl.inputName())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives
          .TemplateInputName(value)
      )
    override val dataType
        : Optional[zio.aws.migrationhuborchestrator.model.DataType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.DataType.wrap(value)
        )
    override val required: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateInput
  ): zio.aws.migrationhuborchestrator.model.TemplateInput.ReadOnly =
    new Wrapper(impl)
}
