package zio.aws.migrationhuborchestrator.model
import scala.jdk.CollectionConverters.*
sealed trait RunEnvironment {
  def unwrap: software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment
}
object RunEnvironment {
  def wrap(
      value: software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment
  ): zio.aws.migrationhuborchestrator.model.RunEnvironment = value match {
    case software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment.AWS =>
      val r = AWS
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment.ONPREMISE =>
      val r = ONPREMISE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhuborchestrator.model.RunEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment =
      software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS
      extends zio.aws.migrationhuborchestrator.model.RunEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment =
      software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment.AWS
  }
  case object ONPREMISE
      extends zio.aws.migrationhuborchestrator.model.RunEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment =
      software.amazon.awssdk.services.migrationhuborchestrator.model.RunEnvironment.ONPREMISE
  }
}
