package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTemplateStepsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    templateStepSummaryList: Optional[
      Iterable[zio.aws.migrationhuborchestrator.model.TemplateStepSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse = {
    import ListTemplateStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        templateStepSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.templateStepSummaryList)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse
      .wrap(buildAwsValue())
}
object ListTemplateStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse =
      zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse(
        nextToken.map(value => value),
        templateStepSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def templateStepSummaryList: Optional[
      List[zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateStepSummaryList: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "templateStepSummaryList",
      templateStepSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse
  ) extends zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val templateStepSummaryList: Optional[
      List[zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.templateStepSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.TemplateStepSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsResponse
  ): zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.ReadOnly =
    new Wrapper(impl)
}
