package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  Timestamp,
  StringListMember
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateWorkflowStepGroupResponse(
    workflowId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    tools: Optional[Iterable[zio.aws.migrationhuborchestrator.model.Tool]] =
      Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse = {
    import UpdateWorkflowStepGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse
      .builder()
      .optionallyWith(workflowId.map(value => value: java.lang.String))(
        _.workflowId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tools)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse
      .wrap(buildAwsValue())
}
object UpdateWorkflowStepGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse =
      zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse(
        workflowId.map(value => value),
        name.map(value => value),
        id.map(value => value),
        description.map(value => value),
        tools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        next.map(value => value),
        previous.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def workflowId: Optional[String]
    def name: Optional[String]
    def id: Optional[String]
    def description: Optional[String]
    def tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]]
    def next: Optional[List[StringListMember]]
    def previous: Optional[List[StringListMember]]
    def lastModifiedTime: Optional[Timestamp]
    def getWorkflowId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTools: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.Tool.ReadOnly
    ]] = AwsError.unwrapOptionField("tools", tools)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse
  ) extends zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.ReadOnly {
    override val workflowId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.Tool.wrap(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse
  ): zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.ReadOnly =
    new Wrapper(impl)
}
