package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  StepInputParametersKey,
  UpdateMigrationWorkflowRequestNameString,
  MigrationWorkflowId,
  UpdateMigrationWorkflowRequestDescriptionString
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateWorkflowRequest(
    id: MigrationWorkflowId,
    name: Optional[UpdateMigrationWorkflowRequestNameString] = Optional.Absent,
    description: Optional[UpdateMigrationWorkflowRequestDescriptionString] =
      Optional.Absent,
    inputParameters: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput
    ]] = Optional.Absent,
    stepTargets: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowRequest = {
    import UpdateWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowRequest
      .builder()
      .id(MigrationWorkflowId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value =>
          UpdateMigrationWorkflowRequestNameString.unwrap(
            value
          ): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value =>
          UpdateMigrationWorkflowRequestDescriptionString.unwrap(
            value
          ): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        inputParameters.map(value =>
          value
            .map({ case (key, value) =>
              (StepInputParametersKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.inputParameters)
      .optionallyWith(
        stepTargets.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stepTargets)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.UpdateWorkflowRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.UpdateWorkflowRequest
      .wrap(buildAwsValue())
}
object UpdateWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.UpdateWorkflowRequest =
      zio.aws.migrationhuborchestrator.model.UpdateWorkflowRequest(
        id,
        name.map(value => value),
        description.map(value => value),
        inputParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stepTargets.map(value => value)
      )
    def id: MigrationWorkflowId
    def name: Optional[UpdateMigrationWorkflowRequestNameString]
    def description: Optional[UpdateMigrationWorkflowRequestDescriptionString]
    def inputParameters: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]]
    def stepTargets: Optional[List[StringListMember]]
    def getId: ZIO[Any, Nothing, MigrationWorkflowId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, UpdateMigrationWorkflowRequestNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription
        : ZIO[Any, AwsError, UpdateMigrationWorkflowRequestDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getInputParameters: ZIO[Any, AwsError, Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]] = AwsError.unwrapOptionField("inputParameters", inputParameters)
    def getStepTargets: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("stepTargets", stepTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowRequest
  ) extends zio.aws.migrationhuborchestrator.model.UpdateWorkflowRequest.ReadOnly {
    override val id: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.id())
    override val name: Optional[UpdateMigrationWorkflowRequestNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.primitives
            .UpdateMigrationWorkflowRequestNameString(value)
        )
    override val description
        : Optional[UpdateMigrationWorkflowRequestDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.primitives
            .UpdateMigrationWorkflowRequestDescriptionString(value)
        )
    override val inputParameters: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.inputParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StepInputParametersKey(
                key
              ) -> zio.aws.migrationhuborchestrator.model.StepInput.wrap(value)
          })
          .toMap
      )
    override val stepTargets: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowRequest
  ): zio.aws.migrationhuborchestrator.model.UpdateWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
