package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  StringMapValue,
  Integer,
  StringMapKey,
  StringValue
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StepInput(
    integerValue: Optional[Integer] = Optional.Absent,
    stringValue: Optional[StringValue] = Optional.Absent,
    listOfStringsValue: Optional[Iterable[StringListMember]] = Optional.Absent,
    mapOfStringValue: Optional[Map[StringMapKey, StringMapValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput = {
    import StepInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput
      .builder()
      .optionallyWith(integerValue.map(value => value: java.lang.Integer))(
        _.integerValue
      )
      .optionallyWith(
        stringValue.map(value => StringValue.unwrap(value): java.lang.String)
      )(_.stringValue)
      .optionallyWith(
        listOfStringsValue.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.listOfStringsValue)
      .optionallyWith(
        mapOfStringValue.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.mapOfStringValue)
      .build()
  }
  def asReadOnly: zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly =
    zio.aws.migrationhuborchestrator.model.StepInput.wrap(buildAwsValue())
}
object StepInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.StepInput =
      zio.aws.migrationhuborchestrator.model.StepInput(
        integerValue.map(value => value),
        stringValue.map(value => value),
        listOfStringsValue.map(value => value),
        mapOfStringValue.map(value => value)
      )
    def integerValue: Optional[Integer]
    def stringValue: Optional[StringValue]
    def listOfStringsValue: Optional[List[StringListMember]]
    def mapOfStringValue: Optional[Map[StringMapKey, StringMapValue]]
    def getIntegerValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("integerValue", integerValue)
    def getStringValue: ZIO[Any, AwsError, StringValue] =
      AwsError.unwrapOptionField("stringValue", stringValue)
    def getListOfStringsValue: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("listOfStringsValue", listOfStringsValue)
    def getMapOfStringValue
        : ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField("mapOfStringValue", mapOfStringValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput
  ) extends zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly {
    override val integerValue: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.integerValue())
      .map(value => value: Integer)
    override val stringValue: Optional[StringValue] = zio.aws.core.internal
      .optionalFromNullable(impl.stringValue())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.StringValue(value)
      )
    override val listOfStringsValue: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.listOfStringsValue())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val mapOfStringValue: Optional[Map[StringMapKey, StringMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mapOfStringValue())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhuborchestrator.model.primitives.StringMapKey(
                key
              ) -> zio.aws.migrationhuborchestrator.model.primitives
                .StringMapValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StepInput
  ): zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly = new Wrapper(
    impl
  )
}
