package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  Integer,
  Timestamp,
  StringListMember
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetWorkflowStepResponse(
    name: Optional[String] = Optional.Absent,
    stepGroupId: Optional[String] = Optional.Absent,
    workflowId: Optional[String] = Optional.Absent,
    stepId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    stepActionType: Optional[
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = Optional.Absent,
    owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      Optional.Absent,
    workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration
    ] = Optional.Absent,
    stepTarget: Optional[Iterable[StringListMember]] = Optional.Absent,
    outputs: Optional[
      Iterable[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput]
    ] = Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.StepStatus] =
      Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    scriptOutputLocation: Optional[String] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastStartTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    noOfSrvCompleted: Optional[Integer] = Optional.Absent,
    noOfSrvFailed: Optional[Integer] = Optional.Absent,
    totalNoOfSrv: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepResponse = {
    import GetWorkflowStepResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepResponse
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(stepGroupId.map(value => value: java.lang.String))(
        _.stepGroupId
      )
      .optionallyWith(workflowId.map(value => value: java.lang.String))(
        _.workflowId
      )
      .optionallyWith(stepId.map(value => value: java.lang.String))(_.stepId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(stepActionType.map(value => value.unwrap))(
        _.stepActionType
      )
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .optionallyWith(
        workflowStepAutomationConfiguration.map(value => value.buildAwsValue())
      )(_.workflowStepAutomationConfiguration)
      .optionallyWith(
        stepTarget.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stepTarget)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        scriptOutputLocation.map(value => value: java.lang.String)
      )(_.scriptOutputLocation)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStartTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(noOfSrvCompleted.map(value => value: java.lang.Integer))(
        _.noOfSrvCompleted
      )
      .optionallyWith(noOfSrvFailed.map(value => value: java.lang.Integer))(
        _.noOfSrvFailed
      )
      .optionallyWith(totalNoOfSrv.map(value => value: java.lang.Integer))(
        _.totalNoOfSrv
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse
      .wrap(buildAwsValue())
}
object GetWorkflowStepResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse =
      zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse(
        name.map(value => value),
        stepGroupId.map(value => value),
        workflowId.map(value => value),
        stepId.map(value => value),
        description.map(value => value),
        stepActionType.map(value => value),
        owner.map(value => value),
        workflowStepAutomationConfiguration.map(value => value.asEditable),
        stepTarget.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        previous.map(value => value),
        next.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        scriptOutputLocation.map(value => value),
        creationTime.map(value => value),
        lastStartTime.map(value => value),
        endTime.map(value => value),
        noOfSrvCompleted.map(value => value),
        noOfSrvFailed.map(value => value),
        totalNoOfSrv.map(value => value)
      )
    def name: Optional[String]
    def stepGroupId: Optional[String]
    def workflowId: Optional[String]
    def stepId: Optional[String]
    def description: Optional[String]
    def stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType]
    def owner: Optional[zio.aws.migrationhuborchestrator.model.Owner]
    def workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ]
    def stepTarget: Optional[List[StringListMember]]
    def outputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly]
    ]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def status: Optional[zio.aws.migrationhuborchestrator.model.StepStatus]
    def statusMessage: Optional[String]
    def scriptOutputLocation: Optional[String]
    def creationTime: Optional[Timestamp]
    def lastStartTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def noOfSrvCompleted: Optional[Integer]
    def noOfSrvFailed: Optional[Integer]
    def totalNoOfSrv: Optional[Integer]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStepGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepGroupId", stepGroupId)
    def getWorkflowId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getStepId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepId", stepId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStepActionType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = AwsError.unwrapOptionField("stepActionType", stepActionType)
    def getOwner
        : ZIO[Any, AwsError, zio.aws.migrationhuborchestrator.model.Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getWorkflowStepAutomationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "workflowStepAutomationConfiguration",
      workflowStepAutomationConfiguration
    )
    def getStepTarget: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("stepTarget", stepTarget)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getScriptOutputLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scriptOutputLocation", scriptOutputLocation)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStartTime", lastStartTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getNoOfSrvCompleted: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("noOfSrvCompleted", noOfSrvCompleted)
    def getNoOfSrvFailed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("noOfSrvFailed", noOfSrvFailed)
    def getTotalNoOfSrv: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalNoOfSrv", totalNoOfSrv)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepResponse
  ) extends zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val stepGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepGroupId())
      .map(value => value: String)
    override val workflowId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => value: String)
    override val stepId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepActionType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepActionType.wrap(value)
        )
    override val owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.migrationhuborchestrator.model.Owner.wrap(value))
    override val workflowStepAutomationConfiguration: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowStepAutomationConfiguration())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration
          .wrap(value)
      )
    override val stepTarget: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepTarget())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val outputs: Optional[
      List[zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.wrap(item)
        }.toList
      )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.StepStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepStatus.wrap(value)
        )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val scriptOutputLocation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptOutputLocation())
      .map(value => value: String)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val lastStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStartTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val noOfSrvCompleted: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.noOfSrvCompleted())
      .map(value => value: Integer)
    override val noOfSrvFailed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.noOfSrvFailed())
      .map(value => value: Integer)
    override val totalNoOfSrv: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalNoOfSrv())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepResponse
  ): zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.ReadOnly =
    new Wrapper(impl)
}
