package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  Timestamp,
  MigrationWorkflowId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class StopWorkflowResponse(
    id: Optional[MigrationWorkflowId] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    lastStopTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.StopWorkflowResponse = {
    import StopWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.StopWorkflowResponse
      .builder()
      .optionallyWith(
        id.map(value => MigrationWorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        lastStopTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStopTime)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.StopWorkflowResponse
      .wrap(buildAwsValue())
}
object StopWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.StopWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.StopWorkflowResponse =
      zio.aws.migrationhuborchestrator.model.StopWorkflowResponse(
        id.map(value => value),
        arn.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        lastStopTime.map(value => value)
      )
    def id: Optional[MigrationWorkflowId]
    def arn: Optional[String]
    def status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ]
    def statusMessage: Optional[String]
    def lastStopTime: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, MigrationWorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getLastStopTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStopTime", lastStopTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StopWorkflowResponse
  ) extends zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.ReadOnly {
    override val id: Optional[MigrationWorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives
          .MigrationWorkflowId(value)
      )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
          .wrap(value)
      )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val lastStopTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStopTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StopWorkflowResponse
  ): zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.ReadOnly =
    new Wrapper(impl)
}
