package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.{
  StepId,
  StepGroupId,
  MigrationWorkflowId
}
import scala.jdk.CollectionConverters.*
final case class RetryWorkflowStepRequest(
    workflowId: MigrationWorkflowId,
    stepGroupId: StepGroupId,
    id: StepId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepRequest = {
    import RetryWorkflowStepRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepRequest
      .builder()
      .workflowId(MigrationWorkflowId.unwrap(workflowId): java.lang.String)
      .stepGroupId(StepGroupId.unwrap(stepGroupId): java.lang.String)
      .id(StepId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.RetryWorkflowStepRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.RetryWorkflowStepRequest
      .wrap(buildAwsValue())
}
object RetryWorkflowStepRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.RetryWorkflowStepRequest =
      zio.aws.migrationhuborchestrator.model
        .RetryWorkflowStepRequest(workflowId, stepGroupId, id)
    def workflowId: MigrationWorkflowId
    def stepGroupId: StepGroupId
    def id: StepId
    def getWorkflowId: ZIO[Any, Nothing, MigrationWorkflowId] =
      ZIO.succeed(workflowId)
    def getStepGroupId: ZIO[Any, Nothing, StepGroupId] =
      ZIO.succeed(stepGroupId)
    def getId: ZIO[Any, Nothing, StepId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepRequest
  ) extends zio.aws.migrationhuborchestrator.model.RetryWorkflowStepRequest.ReadOnly {
    override val workflowId: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.workflowId())
    override val stepGroupId: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives
        .StepGroupId(impl.stepGroupId())
    override val id: StepId =
      zio.aws.migrationhuborchestrator.model.primitives.StepId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepRequest
  ): zio.aws.migrationhuborchestrator.model.RetryWorkflowStepRequest.ReadOnly =
    new Wrapper(impl)
}
