package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  Integer,
  Timestamp,
  MigrationWorkflowId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class MigrationWorkflowSummary(
    id: Optional[MigrationWorkflowId] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    templateId: Optional[String] = Optional.Absent,
    adsApplicationConfigurationName: Optional[String] = Optional.Absent,
    status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    completedSteps: Optional[Integer] = Optional.Absent,
    totalSteps: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary = {
    import MigrationWorkflowSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary
      .builder()
      .optionallyWith(
        id.map(value => MigrationWorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .optionallyWith(
        adsApplicationConfigurationName.map(value => value: java.lang.String)
      )(_.adsApplicationConfigurationName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(completedSteps.map(value => value: java.lang.Integer))(
        _.completedSteps
      )
      .optionallyWith(totalSteps.map(value => value: java.lang.Integer))(
        _.totalSteps
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly =
    zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary
      .wrap(buildAwsValue())
}
object MigrationWorkflowSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary =
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary(
        id.map(value => value),
        name.map(value => value),
        templateId.map(value => value),
        adsApplicationConfigurationName.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        endTime.map(value => value),
        statusMessage.map(value => value),
        completedSteps.map(value => value),
        totalSteps.map(value => value)
      )
    def id: Optional[MigrationWorkflowId]
    def name: Optional[String]
    def templateId: Optional[String]
    def adsApplicationConfigurationName: Optional[String]
    def status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ]
    def creationTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def statusMessage: Optional[String]
    def completedSteps: Optional[Integer]
    def totalSteps: Optional[Integer]
    def getId: ZIO[Any, AwsError, MigrationWorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getAdsApplicationConfigurationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "adsApplicationConfigurationName",
        adsApplicationConfigurationName
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCompletedSteps: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("completedSteps", completedSteps)
    def getTotalSteps: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalSteps", totalSteps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary
  ) extends zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly {
    override val id: Optional[MigrationWorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives
          .MigrationWorkflowId(value)
      )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val templateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: String)
    override val adsApplicationConfigurationName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adsApplicationConfigurationName())
        .map(value => value: String)
    override val status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
          .wrap(value)
      )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val completedSteps: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.completedSteps())
      .map(value => value: Integer)
    override val totalSteps: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalSteps())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.MigrationWorkflowSummary
  ): zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly =
    new Wrapper(impl)
}
