package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWorkflowsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    migrationWorkflowSummary: Iterable[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse = {
    import ListWorkflowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .migrationWorkflowSummary(migrationWorkflowSummary.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse
      .wrap(buildAwsValue())
}
object ListWorkflowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse =
      zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse(
        nextToken.map(value => value),
        migrationWorkflowSummary.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def migrationWorkflowSummary: List[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMigrationWorkflowSummary: ZIO[Any, Nothing, List[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly
    ]] = ZIO.succeed(migrationWorkflowSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse
  ) extends zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val migrationWorkflowSummary: List[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly
    ] = impl
      .migrationWorkflowSummary()
      .asScala
      .map { item =>
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsResponse
  ): zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.ReadOnly =
    new Wrapper(impl)
}
