package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWorkflowStepsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    workflowStepsSummary: Iterable[
      zio.aws.migrationhuborchestrator.model.WorkflowStepSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse = {
    import ListWorkflowStepsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflowStepsSummary(workflowStepsSummary.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse
      .wrap(buildAwsValue())
}
object ListWorkflowStepsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse =
      zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse(
        nextToken.map(value => value),
        workflowStepsSummary.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def workflowStepsSummary: List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowStepsSummary: ZIO[Any, Nothing, List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly
    ]] = ZIO.succeed(workflowStepsSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse
  ) extends zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val workflowStepsSummary: List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly
    ] = impl
      .workflowStepsSummary()
      .asScala
      .map { item =>
        zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsResponse
  ): zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.ReadOnly =
    new Wrapper(impl)
}
