package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTemplateStepGroupsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    templateStepGroupSummary: Iterable[
      zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse = {
    import ListTemplateStepGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templateStepGroupSummary(templateStepGroupSummary.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
      .wrap(buildAwsValue())
}
object ListTemplateStepGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse =
      zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse(
        nextToken.map(value => value),
        templateStepGroupSummary.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def templateStepGroupSummary: List[
      zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateStepGroupSummary: ZIO[Any, Nothing, List[
      zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly
    ]] = ZIO.succeed(templateStepGroupSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
  ) extends zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val templateStepGroupSummary: List[
      zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly
    ] = impl
      .templateStepGroupSummary()
      .asScala
      .map { item =>
        zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
  ): zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
