package zio.aws.migrationhuborchestrator.model
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  TemplateId,
  NextToken,
  MaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTemplateStepGroupsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    templateId: TemplateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest = {
    import ListTemplateStepGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
      .wrap(buildAwsValue())
}
object ListTemplateStepGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsRequest =
      zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        templateId
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def templateId: TemplateId
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
  ) extends zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val templateId: TemplateId =
      zio.aws.migrationhuborchestrator.model.primitives
        .TemplateId(impl.templateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
  ): zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
