package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.StringListMember
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowStepGroupSummary(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      Optional.Absent,
    status: Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus] =
      Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupSummary = {
    import WorkflowStepGroupSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupSummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly =
    zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary
      .wrap(buildAwsValue())
}
object WorkflowStepGroupSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary =
      zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary(
        id.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        status.map(value => value),
        previous.map(value => value),
        next.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def owner: Optional[zio.aws.migrationhuborchestrator.model.Owner]
    def status: Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getOwner
        : ZIO[Any, AwsError, zio.aws.migrationhuborchestrator.model.Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepGroupStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupSummary
  ) extends zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.migrationhuborchestrator.model.Owner.wrap(value))
    override val status
        : Optional[zio.aws.migrationhuborchestrator.model.StepGroupStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepGroupStatus.wrap(value)
        )
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepGroupSummary
  ): zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly =
    new Wrapper(impl)
}
