package zio.aws.migrationhuborchestrator.model
import scala.jdk.CollectionConverters.*
sealed trait StepActionType {
  def unwrap: software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType
}
object StepActionType {
  def wrap(
      value: software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType
  ): zio.aws.migrationhuborchestrator.model.StepActionType = value match {
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType.MANUAL =>
      val r = MANUAL
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType.AUTOMATED =>
      val r = AUTOMATED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhuborchestrator.model.StepActionType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object MANUAL
      extends zio.aws.migrationhuborchestrator.model.StepActionType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType.MANUAL
  }
  case object AUTOMATED
      extends zio.aws.migrationhuborchestrator.model.StepActionType {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepActionType.AUTOMATED
  }
}
