package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWorkflowStepResponse(
    id: Optional[String] = Optional.Absent,
    stepGroupId: Optional[String] = Optional.Absent,
    workflowId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepResponse = {
    import CreateWorkflowStepResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepResponse
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(stepGroupId.map(value => value: java.lang.String))(
        _.stepGroupId
      )
      .optionallyWith(workflowId.map(value => value: java.lang.String))(
        _.workflowId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse
      .wrap(buildAwsValue())
}
object CreateWorkflowStepResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse =
      zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse(
        id.map(value => value),
        stepGroupId.map(value => value),
        workflowId.map(value => value),
        name.map(value => value)
      )
    def id: Optional[String]
    def stepGroupId: Optional[String]
    def workflowId: Optional[String]
    def name: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getStepGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepGroupId", stepGroupId)
    def getWorkflowId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepResponse
  ) extends zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val stepGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepGroupId())
      .map(value => value: String)
    override val workflowId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepResponse
  ): zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.ReadOnly =
    new Wrapper(impl)
}
