package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.WorkflowStepOutputName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WorkflowStepOutput(
    name: Optional[WorkflowStepOutputName] = Optional.Absent,
    dataType: Optional[zio.aws.migrationhuborchestrator.model.DataType] =
      Optional.Absent,
    required: Optional[Boolean] = Optional.Absent,
    value: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput = {
    import WorkflowStepOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput
      .builder()
      .optionallyWith(
        name.map(value =>
          WorkflowStepOutputName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(dataType.map(value => value.unwrap))(_.dataType)
      .optionallyWith(required.map(value => value: java.lang.Boolean))(
        _.required
      )
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly =
    zio.aws.migrationhuborchestrator.model.WorkflowStepOutput
      .wrap(buildAwsValue())
}
object WorkflowStepOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.WorkflowStepOutput =
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutput(
        name.map(value => value),
        dataType.map(value => value),
        required.map(value => value),
        value.map(value => value.asEditable)
      )
    def name: Optional[WorkflowStepOutputName]
    def dataType: Optional[zio.aws.migrationhuborchestrator.model.DataType]
    def required: Optional[Boolean]
    def value: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, WorkflowStepOutputName] =
      AwsError.unwrapOptionField("name", name)
    def getDataType
        : ZIO[Any, AwsError, zio.aws.migrationhuborchestrator.model.DataType] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("required", required)
    def getValue: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion.ReadOnly
    ] = AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput
  ) extends zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly {
    override val name: Optional[WorkflowStepOutputName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives
          .WorkflowStepOutputName(value)
      )
    override val dataType
        : Optional[zio.aws.migrationhuborchestrator.model.DataType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.DataType.wrap(value)
        )
    override val required: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.required())
      .map(value => value: Boolean)
    override val value: Optional[
      zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.WorkflowStepOutputUnion
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.WorkflowStepOutput
  ): zio.aws.migrationhuborchestrator.model.WorkflowStepOutput.ReadOnly =
    new Wrapper(impl)
}
