package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.S3Key
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PlatformScriptKey(
    linux: Optional[S3Key] = Optional.Absent,
    windows: Optional[S3Key] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformScriptKey = {
    import PlatformScriptKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformScriptKey
      .builder()
      .optionallyWith(
        linux.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.linux)
      .optionallyWith(
        windows.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.windows)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.PlatformScriptKey.ReadOnly =
    zio.aws.migrationhuborchestrator.model.PlatformScriptKey
      .wrap(buildAwsValue())
}
object PlatformScriptKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformScriptKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.PlatformScriptKey =
      zio.aws.migrationhuborchestrator.model.PlatformScriptKey(
        linux.map(value => value),
        windows.map(value => value)
      )
    def linux: Optional[S3Key]
    def windows: Optional[S3Key]
    def getLinux: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("linux", linux)
    def getWindows: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("windows", windows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformScriptKey
  ) extends zio.aws.migrationhuborchestrator.model.PlatformScriptKey.ReadOnly {
    override val linux: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.linux())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.S3Key(value)
      )
    override val windows: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.windows())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.S3Key(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.PlatformScriptKey
  ): zio.aws.migrationhuborchestrator.model.PlatformScriptKey.ReadOnly =
    new Wrapper(impl)
}
