package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTemplatesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    templateSummary: Iterable[
      zio.aws.migrationhuborchestrator.model.TemplateSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse = {
    import ListTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templateSummary(templateSummary.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListTemplatesResponse
      .wrap(buildAwsValue())
}
object ListTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListTemplatesResponse =
      zio.aws.migrationhuborchestrator.model.ListTemplatesResponse(
        nextToken.map(value => value),
        templateSummary.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def templateSummary
        : List[zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateSummary: ZIO[Any, Nothing, List[
      zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly
    ]] = ZIO.succeed(templateSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse
  ) extends zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val templateSummary: List[
      zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly
    ] = impl
      .templateSummary()
      .asScala
      .map { item =>
        zio.aws.migrationhuborchestrator.model.TemplateSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesResponse
  ): zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
