package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.StringListMember
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateStepSummary(
    id: Optional[String] = Optional.Absent,
    stepGroupId: Optional[String] = Optional.Absent,
    templateId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    stepActionType: Optional[
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = Optional.Absent,
    targetType: Optional[zio.aws.migrationhuborchestrator.model.TargetType] =
      Optional.Absent,
    owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      Optional.Absent,
    previous: Optional[Iterable[StringListMember]] = Optional.Absent,
    next: Optional[Iterable[StringListMember]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummary = {
    import TemplateStepSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(stepGroupId.map(value => value: java.lang.String))(
        _.stepGroupId
      )
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(stepActionType.map(value => value.unwrap))(
        _.stepActionType
      )
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .optionallyWith(
        previous.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.previous)
      .optionallyWith(
        next.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.next)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly =
    zio.aws.migrationhuborchestrator.model.TemplateStepSummary
      .wrap(buildAwsValue())
}
object TemplateStepSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.TemplateStepSummary =
      zio.aws.migrationhuborchestrator.model.TemplateStepSummary(
        id.map(value => value),
        stepGroupId.map(value => value),
        templateId.map(value => value),
        name.map(value => value),
        stepActionType.map(value => value),
        targetType.map(value => value),
        owner.map(value => value),
        previous.map(value => value),
        next.map(value => value)
      )
    def id: Optional[String]
    def stepGroupId: Optional[String]
    def templateId: Optional[String]
    def name: Optional[String]
    def stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType]
    def targetType: Optional[zio.aws.migrationhuborchestrator.model.TargetType]
    def owner: Optional[zio.aws.migrationhuborchestrator.model.Owner]
    def previous: Optional[List[StringListMember]]
    def next: Optional[List[StringListMember]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getStepGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stepGroupId", stepGroupId)
    def getTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStepActionType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.StepActionType
    ] = AwsError.unwrapOptionField("stepActionType", stepActionType)
    def getTargetType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.TargetType
    ] = AwsError.unwrapOptionField("targetType", targetType)
    def getOwner
        : ZIO[Any, AwsError, zio.aws.migrationhuborchestrator.model.Owner] =
      AwsError.unwrapOptionField("owner", owner)
    def getPrevious: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("previous", previous)
    def getNext: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummary
  ) extends zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val stepGroupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stepGroupId())
      .map(value => value: String)
    override val templateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val stepActionType
        : Optional[zio.aws.migrationhuborchestrator.model.StepActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepActionType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.StepActionType.wrap(value)
        )
    override val targetType
        : Optional[zio.aws.migrationhuborchestrator.model.TargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.TargetType.wrap(value)
        )
    override val owner: Optional[zio.aws.migrationhuborchestrator.model.Owner] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.migrationhuborchestrator.model.Owner.wrap(value))
    override val previous: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.previous())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val next: Optional[List[StringListMember]] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.primitives
            .StringListMember(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateStepSummary
  ): zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly =
    new Wrapper(impl)
}
