package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StepAutomationConfiguration(
    scriptLocationS3Bucket: Optional[String] = Optional.Absent,
    scriptLocationS3Key: Optional[
      zio.aws.migrationhuborchestrator.model.PlatformScriptKey
    ] = Optional.Absent,
    command: Optional[zio.aws.migrationhuborchestrator.model.PlatformCommand] =
      Optional.Absent,
    runEnvironment: Optional[
      zio.aws.migrationhuborchestrator.model.RunEnvironment
    ] = Optional.Absent,
    targetType: Optional[zio.aws.migrationhuborchestrator.model.TargetType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.StepAutomationConfiguration = {
    import StepAutomationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.StepAutomationConfiguration
      .builder()
      .optionallyWith(
        scriptLocationS3Bucket.map(value => value: java.lang.String)
      )(_.scriptLocationS3Bucket)
      .optionallyWith(scriptLocationS3Key.map(value => value.buildAwsValue()))(
        _.scriptLocationS3Key
      )
      .optionallyWith(command.map(value => value.buildAwsValue()))(_.command)
      .optionallyWith(runEnvironment.map(value => value.unwrap))(
        _.runEnvironment
      )
      .optionallyWith(targetType.map(value => value.unwrap))(_.targetType)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration.ReadOnly =
    zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration
      .wrap(buildAwsValue())
}
object StepAutomationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.StepAutomationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration =
      zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration(
        scriptLocationS3Bucket.map(value => value),
        scriptLocationS3Key.map(value => value.asEditable),
        command.map(value => value.asEditable),
        runEnvironment.map(value => value),
        targetType.map(value => value)
      )
    def scriptLocationS3Bucket: Optional[String]
    def scriptLocationS3Key: Optional[
      zio.aws.migrationhuborchestrator.model.PlatformScriptKey.ReadOnly
    ]
    def command: Optional[
      zio.aws.migrationhuborchestrator.model.PlatformCommand.ReadOnly
    ]
    def runEnvironment
        : Optional[zio.aws.migrationhuborchestrator.model.RunEnvironment]
    def targetType: Optional[zio.aws.migrationhuborchestrator.model.TargetType]
    def getScriptLocationS3Bucket: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("scriptLocationS3Bucket", scriptLocationS3Bucket)
    def getScriptLocationS3Key: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.PlatformScriptKey.ReadOnly
    ] = AwsError.unwrapOptionField("scriptLocationS3Key", scriptLocationS3Key)
    def getCommand: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.PlatformCommand.ReadOnly
    ] = AwsError.unwrapOptionField("command", command)
    def getRunEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.RunEnvironment
    ] = AwsError.unwrapOptionField("runEnvironment", runEnvironment)
    def getTargetType: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.TargetType
    ] = AwsError.unwrapOptionField("targetType", targetType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StepAutomationConfiguration
  ) extends zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration.ReadOnly {
    override val scriptLocationS3Bucket: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scriptLocationS3Bucket())
        .map(value => value: String)
    override val scriptLocationS3Key: Optional[
      zio.aws.migrationhuborchestrator.model.PlatformScriptKey.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scriptLocationS3Key())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.PlatformScriptKey.wrap(value)
      )
    override val command: Optional[
      zio.aws.migrationhuborchestrator.model.PlatformCommand.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.PlatformCommand.wrap(value)
      )
    override val runEnvironment
        : Optional[zio.aws.migrationhuborchestrator.model.RunEnvironment] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runEnvironment())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.RunEnvironment.wrap(value)
        )
    override val targetType
        : Optional[zio.aws.migrationhuborchestrator.model.TargetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetType())
        .map(value =>
          zio.aws.migrationhuborchestrator.model.TargetType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.StepAutomationConfiguration
  ): zio.aws.migrationhuborchestrator.model.StepAutomationConfiguration.ReadOnly =
    new Wrapper(impl)
}
