package zio.aws.migrationhuborchestrator.model
import scala.jdk.CollectionConverters.*
sealed trait PluginHealth {
  def unwrap: software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth
}
object PluginHealth {
  def wrap(
      value: software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth
  ): zio.aws.migrationhuborchestrator.model.PluginHealth = value match {
    case software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth.UNHEALTHY =>
      val r = UNHEALTHY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhuborchestrator.model.PluginHealth {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth =
      software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY
      extends zio.aws.migrationhuborchestrator.model.PluginHealth {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth =
      software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth.HEALTHY
  }
  case object UNHEALTHY
      extends zio.aws.migrationhuborchestrator.model.PluginHealth {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth =
      software.amazon.awssdk.services.migrationhuborchestrator.model.PluginHealth.UNHEALTHY
  }
}
