package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPluginsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    plugins: Optional[
      Iterable[zio.aws.migrationhuborchestrator.model.PluginSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse = {
    import ListPluginsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        plugins.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.plugins)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListPluginsResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListPluginsResponse
      .wrap(buildAwsValue())
}
object ListPluginsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.ListPluginsResponse =
      zio.aws.migrationhuborchestrator.model.ListPluginsResponse(
        nextToken.map(value => value),
        plugins.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def plugins: Optional[
      List[zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPlugins: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("plugins", plugins)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse
  ) extends zio.aws.migrationhuborchestrator.model.ListPluginsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val plugins: Optional[
      List[zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.plugins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.migrationhuborchestrator.model.PluginSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsResponse
  ): zio.aws.migrationhuborchestrator.model.ListPluginsResponse.ReadOnly =
    new Wrapper(impl)
}
