package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  StringListMember,
  StepInputParametersKey,
  MigrationWorkflowId,
  Timestamp,
  StringMapValue,
  StringMapKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateWorkflowResponse(
    id: Optional[MigrationWorkflowId] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    templateId: Optional[String] = Optional.Absent,
    adsApplicationConfigurationId: Optional[String] = Optional.Absent,
    workflowInputs: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput
    ]] = Optional.Absent,
    stepTargets: Optional[Iterable[StringListMember]] = Optional.Absent,
    status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[StringMapKey, StringMapValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowResponse = {
    import CreateWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowResponse
      .builder()
      .optionallyWith(
        id.map(value => MigrationWorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .optionallyWith(
        adsApplicationConfigurationId.map(value => value: java.lang.String)
      )(_.adsApplicationConfigurationId)
      .optionallyWith(
        workflowInputs.map(value =>
          value
            .map({ case (key, value) =>
              (StepInputParametersKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.workflowInputs)
      .optionallyWith(
        stepTargets.map(value =>
          value.map { item =>
            StringListMember.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stepTargets)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse
      .wrap(buildAwsValue())
}
object CreateWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse =
      zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        templateId.map(value => value),
        adsApplicationConfigurationId.map(value => value),
        workflowInputs.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stepTargets.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        tags.map(value => value)
      )
    def id: Optional[MigrationWorkflowId]
    def arn: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def templateId: Optional[String]
    def adsApplicationConfigurationId: Optional[String]
    def workflowInputs: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]]
    def stepTargets: Optional[List[StringListMember]]
    def status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ]
    def creationTime: Optional[Timestamp]
    def tags: Optional[Map[StringMapKey, StringMapValue]]
    def getId: ZIO[Any, AwsError, MigrationWorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getAdsApplicationConfigurationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "adsApplicationConfigurationId",
        adsApplicationConfigurationId
      )
    def getWorkflowInputs: ZIO[Any, AwsError, Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowInputs", workflowInputs)
    def getStepTargets: ZIO[Any, AwsError, List[StringListMember]] =
      AwsError.unwrapOptionField("stepTargets", stepTargets)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowResponse
  ) extends zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.ReadOnly {
    override val id: Optional[MigrationWorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives
          .MigrationWorkflowId(value)
      )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val templateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: String)
    override val adsApplicationConfigurationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adsApplicationConfigurationId())
        .map(value => value: String)
    override val workflowInputs: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowInputs())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StepInputParametersKey(
                key
              ) -> zio.aws.migrationhuborchestrator.model.StepInput.wrap(value)
          })
          .toMap
      )
    override val stepTargets: Optional[List[StringListMember]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StringListMember(item)
          }.toList
        )
    override val status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
          .wrap(value)
      )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val tags: Optional[Map[StringMapKey, StringMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhuborchestrator.model.primitives.StringMapKey(
                key
              ) -> zio.aws.migrationhuborchestrator.model.primitives
                .StringMapValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowResponse
  ): zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.ReadOnly =
    new Wrapper(impl)
}
