package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateSummary(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary = {
    import TemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly =
    zio.aws.migrationhuborchestrator.model.TemplateSummary.wrap(buildAwsValue())
}
object TemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.TemplateSummary =
      zio.aws.migrationhuborchestrator.model.TemplateSummary(
        id.map(value => value),
        name.map(value => value),
        arn.map(value => value),
        description.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def arn: Optional[String]
    def description: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary
  ) extends zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.TemplateSummary
  ): zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly =
    new Wrapper(impl)
}
