package zio.aws.migrationhuborchestrator.model
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  ApplicationConfigurationName,
  TemplateId,
  NextToken,
  MaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWorkflowsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    templateId: Optional[TemplateId] = Optional.Absent,
    adsApplicationConfigurationName: Optional[ApplicationConfigurationName] =
      Optional.Absent,
    status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = Optional.Absent,
    name: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest = {
    import ListWorkflowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        templateId.map(value => TemplateId.unwrap(value): java.lang.String)
      )(_.templateId)
      .optionallyWith(
        adsApplicationConfigurationName.map(value =>
          ApplicationConfigurationName.unwrap(value): java.lang.String
        )
      )(_.adsApplicationConfigurationName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListWorkflowsRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListWorkflowsRequest
      .wrap(buildAwsValue())
}
object ListWorkflowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListWorkflowsRequest =
      zio.aws.migrationhuborchestrator.model.ListWorkflowsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        templateId.map(value => value),
        adsApplicationConfigurationName.map(value => value),
        status.map(value => value),
        name.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def templateId: Optional[TemplateId]
    def adsApplicationConfigurationName: Optional[ApplicationConfigurationName]
    def status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ]
    def name: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateId: ZIO[Any, AwsError, TemplateId] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getAdsApplicationConfigurationName
        : ZIO[Any, AwsError, ApplicationConfigurationName] =
      AwsError.unwrapOptionField(
        "adsApplicationConfigurationName",
        adsApplicationConfigurationName
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest
  ) extends zio.aws.migrationhuborchestrator.model.ListWorkflowsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val templateId: Optional[TemplateId] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.TemplateId(value)
      )
    override val adsApplicationConfigurationName
        : Optional[ApplicationConfigurationName] = zio.aws.core.internal
      .optionalFromNullable(impl.adsApplicationConfigurationName())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives
          .ApplicationConfigurationName(value)
      )
    override val status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
          .wrap(value)
      )
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest
  ): zio.aws.migrationhuborchestrator.model.ListWorkflowsRequest.ReadOnly =
    new Wrapper(impl)
}
