package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.migrationhuborchestrator.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListWorkflowStepGroupsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    workflowStepGroupsSummary: Iterable[
      zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse = {
    import ListWorkflowStepGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflowStepGroupsSummary(workflowStepGroupsSummary.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse
      .wrap(buildAwsValue())
}
object ListWorkflowStepGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse =
      zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse(
        nextToken.map(value => value),
        workflowStepGroupsSummary.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def workflowStepGroupsSummary: List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowStepGroupsSummary: ZIO[Any, Nothing, List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly
    ]] = ZIO.succeed(workflowStepGroupsSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse
  ) extends zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val workflowStepGroupsSummary: List[
      zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly
    ] = impl
      .workflowStepGroupsSummary()
      .asScala
      .map { item =>
        zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse
  ): zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
