package zio.aws.migrationhuborchestrator.model
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  StepGroupId,
  TemplateId,
  NextToken,
  MaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTemplateStepsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    templateId: TemplateId,
    stepGroupId: StepGroupId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest = {
    import ListTemplateStepsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templateId(TemplateId.unwrap(templateId): java.lang.String)
      .stepGroupId(StepGroupId.unwrap(stepGroupId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.ListTemplateStepsRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.ListTemplateStepsRequest
      .wrap(buildAwsValue())
}
object ListTemplateStepsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.migrationhuborchestrator.model.ListTemplateStepsRequest =
      zio.aws.migrationhuborchestrator.model.ListTemplateStepsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        templateId,
        stepGroupId
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def templateId: TemplateId
    def stepGroupId: StepGroupId
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplateId: ZIO[Any, Nothing, TemplateId] = ZIO.succeed(templateId)
    def getStepGroupId: ZIO[Any, Nothing, StepGroupId] =
      ZIO.succeed(stepGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest
  ) extends zio.aws.migrationhuborchestrator.model.ListTemplateStepsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.NextToken(value)
      )
    override val templateId: TemplateId =
      zio.aws.migrationhuborchestrator.model.primitives
        .TemplateId(impl.templateId())
    override val stepGroupId: StepGroupId =
      zio.aws.migrationhuborchestrator.model.primitives
        .StepGroupId(impl.stepGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest
  ): zio.aws.migrationhuborchestrator.model.ListTemplateStepsRequest.ReadOnly =
    new Wrapper(impl)
}
