package zio.aws.migrationhuborchestrator.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.migrationhuborchestrator.model.primitives.{
  StepInputParametersKey,
  MigrationWorkflowId,
  Timestamp,
  StringMapValue,
  Integer,
  StringMapKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class GetWorkflowResponse(
    id: Optional[MigrationWorkflowId] = Optional.Absent,
    arn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    templateId: Optional[String] = Optional.Absent,
    adsApplicationConfigurationId: Optional[String] = Optional.Absent,
    adsApplicationName: Optional[String] = Optional.Absent,
    status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastStartTime: Optional[Timestamp] = Optional.Absent,
    lastStopTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    tools: Optional[Iterable[zio.aws.migrationhuborchestrator.model.Tool]] =
      Optional.Absent,
    totalSteps: Optional[Integer] = Optional.Absent,
    completedSteps: Optional[Integer] = Optional.Absent,
    workflowInputs: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput
    ]] = Optional.Absent,
    tags: Optional[Map[StringMapKey, StringMapValue]] = Optional.Absent,
    workflowBucket: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowResponse = {
    import GetWorkflowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowResponse
      .builder()
      .optionallyWith(
        id.map(value => MigrationWorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .optionallyWith(
        adsApplicationConfigurationId.map(value => value: java.lang.String)
      )(_.adsApplicationConfigurationId)
      .optionallyWith(adsApplicationName.map(value => value: java.lang.String))(
        _.adsApplicationName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStartTime)
      .optionallyWith(
        lastStopTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStopTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        tools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tools)
      .optionallyWith(totalSteps.map(value => value: java.lang.Integer))(
        _.totalSteps
      )
      .optionallyWith(completedSteps.map(value => value: java.lang.Integer))(
        _.completedSteps
      )
      .optionallyWith(
        workflowInputs.map(value =>
          value
            .map({ case (key, value) =>
              (StepInputParametersKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.workflowInputs)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (StringMapKey.unwrap(key): java.lang.String) -> (StringMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(workflowBucket.map(value => value: java.lang.String))(
        _.workflowBucket
      )
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetWorkflowResponse
      .wrap(buildAwsValue())
}
object GetWorkflowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.GetWorkflowResponse =
      zio.aws.migrationhuborchestrator.model.GetWorkflowResponse(
        id.map(value => value),
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        templateId.map(value => value),
        adsApplicationConfigurationId.map(value => value),
        adsApplicationName.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        creationTime.map(value => value),
        lastStartTime.map(value => value),
        lastStopTime.map(value => value),
        lastModifiedTime.map(value => value),
        endTime.map(value => value),
        tools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalSteps.map(value => value),
        completedSteps.map(value => value),
        workflowInputs.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        tags.map(value => value),
        workflowBucket.map(value => value)
      )
    def id: Optional[MigrationWorkflowId]
    def arn: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def templateId: Optional[String]
    def adsApplicationConfigurationId: Optional[String]
    def adsApplicationName: Optional[String]
    def status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ]
    def statusMessage: Optional[String]
    def creationTime: Optional[Timestamp]
    def lastStartTime: Optional[Timestamp]
    def lastStopTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]]
    def totalSteps: Optional[Integer]
    def completedSteps: Optional[Integer]
    def workflowInputs: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]]
    def tags: Optional[Map[StringMapKey, StringMapValue]]
    def workflowBucket: Optional[String]
    def getId: ZIO[Any, AwsError, MigrationWorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getAdsApplicationConfigurationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "adsApplicationConfigurationId",
        adsApplicationConfigurationId
      )
    def getAdsApplicationName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("adsApplicationName", adsApplicationName)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStartTime", lastStartTime)
    def getLastStopTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStopTime", lastStopTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getTools: ZIO[Any, AwsError, List[
      zio.aws.migrationhuborchestrator.model.Tool.ReadOnly
    ]] = AwsError.unwrapOptionField("tools", tools)
    def getTotalSteps: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalSteps", totalSteps)
    def getCompletedSteps: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("completedSteps", completedSteps)
    def getWorkflowInputs: ZIO[Any, AwsError, Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowInputs", workflowInputs)
    def getTags: ZIO[Any, AwsError, Map[StringMapKey, StringMapValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkflowBucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workflowBucket", workflowBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowResponse
  ) extends zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.ReadOnly {
    override val id: Optional[MigrationWorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives
          .MigrationWorkflowId(value)
      )
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val templateId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: String)
    override val adsApplicationConfigurationId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adsApplicationConfigurationId())
        .map(value => value: String)
    override val adsApplicationName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.adsApplicationName())
      .map(value => value: String)
    override val status: Optional[
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
          .wrap(value)
      )
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val lastStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStartTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val lastStopTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStopTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value =>
        zio.aws.migrationhuborchestrator.model.primitives.Timestamp(value)
      )
    override val tools
        : Optional[List[zio.aws.migrationhuborchestrator.model.Tool.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.migrationhuborchestrator.model.Tool.wrap(item)
          }.toList
        )
    override val totalSteps: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalSteps())
      .map(value => value: Integer)
    override val completedSteps: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.completedSteps())
      .map(value => value: Integer)
    override val workflowInputs: Optional[Map[
      StepInputParametersKey,
      zio.aws.migrationhuborchestrator.model.StepInput.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowInputs())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.migrationhuborchestrator.model.primitives
              .StepInputParametersKey(
                key
              ) -> zio.aws.migrationhuborchestrator.model.StepInput.wrap(value)
          })
          .toMap
      )
    override val tags: Optional[Map[StringMapKey, StringMapValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.migrationhuborchestrator.model.primitives.StringMapKey(
                key
              ) -> zio.aws.migrationhuborchestrator.model.primitives
                .StringMapValue(value)
            })
            .toMap
        )
    override val workflowBucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowBucket())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowResponse
  ): zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.ReadOnly =
    new Wrapper(impl)
}
