package zio.aws.migrationhuborchestrator.model
import scala.jdk.CollectionConverters.*
sealed trait StepStatus {
  def unwrap: software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus
}
object StepStatus {
  def wrap(
      value: software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus
  ): zio.aws.migrationhuborchestrator.model.StepStatus = value match {
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.AWAITING_DEPENDENCIES =>
      val r = AWAITING_DEPENDENCIES
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.PAUSED =>
      val r = PAUSED
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.USER_ATTENTION_REQUIRED =>
      val r = USER_ATTENTION_REQUIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhuborchestrator.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AWAITING_DEPENDENCIES
      extends zio.aws.migrationhuborchestrator.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.AWAITING_DEPENDENCIES
  }
  case object READY extends zio.aws.migrationhuborchestrator.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.READY
  }
  case object IN_PROGRESS
      extends zio.aws.migrationhuborchestrator.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.IN_PROGRESS
  }
  case object COMPLETED
      extends zio.aws.migrationhuborchestrator.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.COMPLETED
  }
  case object FAILED extends zio.aws.migrationhuborchestrator.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.FAILED
  }
  case object PAUSED extends zio.aws.migrationhuborchestrator.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.PAUSED
  }
  case object USER_ATTENTION_REQUIRED
      extends zio.aws.migrationhuborchestrator.model.StepStatus {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus =
      software.amazon.awssdk.services.migrationhuborchestrator.model.StepStatus.USER_ATTENTION_REQUIRED
  }
}
