package zio.aws.migrationhuborchestrator.model
import scala.jdk.CollectionConverters.*
sealed trait Owner {
  def unwrap
      : software.amazon.awssdk.services.migrationhuborchestrator.model.Owner
}
object Owner {
  def wrap(
      value: software.amazon.awssdk.services.migrationhuborchestrator.model.Owner
  ): zio.aws.migrationhuborchestrator.model.Owner = value match {
    case software.amazon.awssdk.services.migrationhuborchestrator.model.Owner.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.Owner.AWS_MANAGED =>
      val r = AWS_MANAGED
      r
    case software.amazon.awssdk.services.migrationhuborchestrator.model.Owner.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.migrationhuborchestrator.model.Owner {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.Owner =
      software.amazon.awssdk.services.migrationhuborchestrator.model.Owner.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_MANAGED extends zio.aws.migrationhuborchestrator.model.Owner {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.Owner =
      software.amazon.awssdk.services.migrationhuborchestrator.model.Owner.AWS_MANAGED
  }
  case object CUSTOM extends zio.aws.migrationhuborchestrator.model.Owner {
    override def unwrap
        : software.amazon.awssdk.services.migrationhuborchestrator.model.Owner =
      software.amazon.awssdk.services.migrationhuborchestrator.model.Owner.CUSTOM
  }
}
