package zio.aws.migrationhuborchestrator.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.migrationhuborchestrator.model.primitives.MigrationWorkflowId
import scala.jdk.CollectionConverters.*
final case class GetWorkflowRequest(id: MigrationWorkflowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowRequest = {
    import GetWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowRequest
      .builder()
      .id(MigrationWorkflowId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.migrationhuborchestrator.model.GetWorkflowRequest.ReadOnly =
    zio.aws.migrationhuborchestrator.model.GetWorkflowRequest
      .wrap(buildAwsValue())
}
object GetWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.migrationhuborchestrator.model.GetWorkflowRequest =
      zio.aws.migrationhuborchestrator.model.GetWorkflowRequest(id)
    def id: MigrationWorkflowId
    def getId: ZIO[Any, Nothing, MigrationWorkflowId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowRequest
  ) extends zio.aws.migrationhuborchestrator.model.GetWorkflowRequest.ReadOnly {
    override val id: MigrationWorkflowId =
      zio.aws.migrationhuborchestrator.model.primitives
        .MigrationWorkflowId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowRequest
  ): zio.aws.migrationhuborchestrator.model.GetWorkflowRequest.ReadOnly =
    new Wrapper(impl)
}
