package zio.aws.migrationhuborchestrator
import zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.migrationhuborchestrator.model.{
  DeleteWorkflowStepRequest,
  CreateWorkflowStepRequest,
  CreateWorkflowRequest,
  UpdateWorkflowRequest,
  GetWorkflowStepRequest,
  DeleteWorkflowStepGroupRequest,
  UpdateWorkflowStepRequest,
  StartWorkflowRequest,
  ListWorkflowsRequest,
  RetryWorkflowStepRequest,
  GetWorkflowStepGroupRequest,
  ListTagsForResourceRequest,
  GetTemplateStepRequest,
  ListWorkflowStepsRequest,
  UpdateWorkflowStepGroupRequest,
  GetTemplateStepGroupRequest,
  ListWorkflowStepGroupsRequest,
  UntagResourceRequest,
  StopWorkflowRequest,
  CreateWorkflowStepGroupRequest,
  ListTemplateStepGroupsRequest,
  ListPluginsRequest,
  ListTemplatesRequest,
  GetTemplateRequest,
  DeleteWorkflowRequest,
  TagResourceRequest,
  ListTemplateStepsRequest,
  GetWorkflowRequest
}
import software.amazon.awssdk.services.migrationhuborchestrator.model.{
  ListTemplateStepsResponse,
  WorkflowStepSummary,
  ListWorkflowStepsResponse,
  GetTemplateStepResponse,
  DeleteWorkflowResponse,
  ListTemplatesResponse,
  ListTemplateStepGroupsResponse,
  DeleteWorkflowStepResponse,
  StartWorkflowResponse,
  StopWorkflowResponse,
  GetTemplateResponse,
  RetryWorkflowStepResponse,
  UpdateWorkflowResponse,
  CreateWorkflowResponse,
  PluginSummary,
  TemplateStepGroupSummary,
  UpdateWorkflowStepResponse,
  ListTagsForResourceResponse,
  GetWorkflowStepResponse,
  UntagResourceResponse,
  ListWorkflowsResponse,
  ListPluginsResponse,
  DeleteWorkflowStepGroupResponse,
  MigrationWorkflowSummary,
  TemplateStepSummary,
  ListWorkflowStepGroupsResponse,
  GetWorkflowStepGroupResponse,
  UpdateWorkflowStepGroupResponse,
  TemplateSummary,
  GetWorkflowResponse,
  TagResourceResponse,
  CreateWorkflowStepGroupResponse,
  GetTemplateStepGroupResponse,
  WorkflowStepGroupSummary,
  CreateWorkflowStepResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.migrationhuborchestrator.{
  MigrationHubOrchestratorAsyncClientBuilder,
  MigrationHubOrchestratorAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.migrationhuborchestrator.paginators.{
  ListTemplateStepsPublisher,
  ListTemplatesPublisher,
  ListWorkflowStepGroupsPublisher,
  ListWorkflowStepsPublisher,
  ListPluginsPublisher,
  ListTemplateStepGroupsPublisher,
  ListWorkflowsPublisher
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait MigrationHubOrchestrator extends AspectSupport[MigrationHubOrchestrator] {
  val api: MigrationHubOrchestratorAsyncClient
  def getWorkflowStep(request: GetWorkflowStepRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.ReadOnly
  ]
  def listWorkflowSteps(request: ListWorkflowStepsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly
  ]
  def listWorkflowStepsPaginated(request: ListWorkflowStepsRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.ReadOnly
  ]
  def getWorkflowStepGroup(request: GetWorkflowStepGroupRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.ReadOnly
  ]
  def updateWorkflowStep(
      request: UpdateWorkflowStepRequest
  ): IO[AwsError, ReadOnly]
  def retryWorkflowStep(request: RetryWorkflowStepRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.ReadOnly
  ]
  def deleteWorkflowStep(request: DeleteWorkflowStepRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepResponse.ReadOnly
  ]
  def startWorkflow(request: StartWorkflowRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.StartWorkflowResponse.ReadOnly
  ]
  def stopWorkflow(request: StopWorkflowRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.ReadOnly
  ]
  def updateWorkflowStepGroup(request: UpdateWorkflowStepGroupRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.ReadOnly
  ]
  def listTemplates(request: ListTemplatesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly
  ]
  def listTemplatesPaginated(request: ListTemplatesRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.ReadOnly
  ]
  def listPlugins(request: ListPluginsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly
  ]
  def listPluginsPaginated(request: ListPluginsRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListPluginsResponse.ReadOnly
  ]
  def updateWorkflow(request: UpdateWorkflowRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.UpdateWorkflowResponse.ReadOnly
  ]
  def createWorkflowStepGroup(request: CreateWorkflowStepGroupRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.UntagResourceResponse.ReadOnly
  ]
  def getWorkflow(request: GetWorkflowRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.ReadOnly
  ]
  def getTemplateStepGroup(request: GetTemplateStepGroupRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.ReadOnly
  ]
  def listTemplateStepGroups(request: ListTemplateStepGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly
  ]
  def listTemplateStepGroupsPaginated(
      request: ListTemplateStepGroupsRequest
  ): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.TagResourceResponse.ReadOnly
  ]
  def listWorkflows(request: ListWorkflowsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly
  ]
  def listWorkflowsPaginated(request: ListWorkflowsRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.ReadOnly
  ]
  def listTemplateSteps(request: ListTemplateStepsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly
  ]
  def listTemplateStepsPaginated(request: ListTemplateStepsRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.ReadOnly
  ]
  def deleteWorkflowStepGroup(request: DeleteWorkflowStepGroupRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse.ReadOnly
  ]
  def deleteWorkflow(request: DeleteWorkflowRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.ReadOnly
  ]
  def listWorkflowStepGroups(request: ListWorkflowStepGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly
  ]
  def listWorkflowStepGroupsPaginated(
      request: ListWorkflowStepGroupsRequest
  ): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.ReadOnly
  ]
  def createWorkflowStep(request: CreateWorkflowStepRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.ReadOnly
  ]
  def getTemplate(request: GetTemplateRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetTemplateResponse.ReadOnly
  ]
  def getTemplateStep(request: GetTemplateStepRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.ReadOnly
  ]
  def createWorkflow(request: CreateWorkflowRequest): IO[
    AwsError,
    zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.ReadOnly
  ]
}
object MigrationHubOrchestrator {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MigrationHubOrchestrator] =
    customized(identity)
  def customized(
      customization: MigrationHubOrchestratorAsyncClientBuilder => MigrationHubOrchestratorAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MigrationHubOrchestrator] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MigrationHubOrchestratorAsyncClientBuilder => MigrationHubOrchestratorAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, MigrationHubOrchestrator] =
    for (
      awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
      builder = MigrationHubOrchestratorAsyncClient
        .builder()
        .asyncConfiguration(
          software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
            .builder()
            .advancedOption(
              software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
              executor.asJava
            )
            .build()
        );
      b0 <- awsConfig.configure[
        MigrationHubOrchestratorAsyncClient,
        MigrationHubOrchestratorAsyncClientBuilder
      ](builder);
      b1 <- awsConfig.configureHttpClient[
        MigrationHubOrchestratorAsyncClient,
        MigrationHubOrchestratorAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
    )
      yield new MigrationHubOrchestratorImpl(
        client,
        AwsCallAspect.identity,
        ZEnvironment.empty
      )
  private class MigrationHubOrchestratorImpl[R](
      override val api: MigrationHubOrchestratorAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MigrationHubOrchestrator
      with AwsServiceBase[R] {
    override val serviceName: String = "MigrationHubOrchestrator"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MigrationHubOrchestratorImpl[R1] =
      new MigrationHubOrchestratorImpl(api, newAspect, r)
    def getWorkflowStep(request: GetWorkflowStepRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepRequest,
      GetWorkflowStepResponse
    ]("getWorkflowStep", api.getWorkflowStep)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.wrap)
      .provideEnvironment(r)
    def listWorkflowSteps(request: ListWorkflowStepsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest,
      WorkflowStepSummary,
      ListWorkflowStepsPublisher
    ](
      "listWorkflowSteps",
      api.listWorkflowStepsPaginator,
      _.workflowStepsSummary()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listWorkflowStepsPaginated(request: ListWorkflowStepsRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepsRequest,
      ListWorkflowStepsResponse
    ]("listWorkflowSteps", api.listWorkflowSteps)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.wrap
      )
      .provideEnvironment(r)
    def getWorkflowStepGroup(request: GetWorkflowStepGroupRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest,
      GetWorkflowStepGroupResponse
    ]("getWorkflowStepGroup", api.getWorkflowStepGroup)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.wrap
      )
      .provideEnvironment(r)
    def updateWorkflowStep(
        request: UpdateWorkflowStepRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest,
      UpdateWorkflowStepResponse
    ]("updateWorkflowStep", api.updateWorkflowStep)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepResponse.wrap
      )
      .provideEnvironment(r)
    def retryWorkflowStep(request: RetryWorkflowStepRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.RetryWorkflowStepRequest,
      RetryWorkflowStepResponse
    ]("retryWorkflowStep", api.retryWorkflowStep)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.wrap
      )
      .provideEnvironment(r)
    def deleteWorkflowStep(request: DeleteWorkflowStepRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest,
      DeleteWorkflowStepResponse
    ]("deleteWorkflowStep", api.deleteWorkflowStep)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepResponse.wrap
      )
      .provideEnvironment(r)
    def startWorkflow(request: StartWorkflowRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.StartWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.StartWorkflowRequest,
      StartWorkflowResponse
    ]("startWorkflow", api.startWorkflow)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.StartWorkflowResponse.wrap)
      .provideEnvironment(r)
    def stopWorkflow(request: StopWorkflowRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.StopWorkflowRequest,
      StopWorkflowResponse
    ]("stopWorkflow", api.stopWorkflow)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.wrap)
      .provideEnvironment(r)
    def updateWorkflowStepGroup(request: UpdateWorkflowStepGroupRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest,
      UpdateWorkflowStepGroupResponse
    ]("updateWorkflowStepGroup", api.updateWorkflowStepGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.wrap
    ).provideEnvironment(r)
    def listTemplates(request: ListTemplatesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest,
      TemplateSummary,
      ListTemplatesPublisher
    ]("listTemplates", api.listTemplatesPaginator, _.templateSummary())(
      request.buildAwsValue()
    ).map(item =>
      zio.aws.migrationhuborchestrator.model.TemplateSummary.wrap(item)
    ).provideEnvironment(r)
    def listTemplatesPaginated(request: ListTemplatesRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplatesRequest,
      ListTemplatesResponse
    ]("listTemplates", api.listTemplates)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.wrap)
      .provideEnvironment(r)
    def listPlugins(request: ListPluginsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsRequest,
      PluginSummary,
      ListPluginsPublisher
    ]("listPlugins", api.listPluginsPaginator, _.plugins())(
      request.buildAwsValue()
    ).map(item =>
      zio.aws.migrationhuborchestrator.model.PluginSummary.wrap(item)
    ).provideEnvironment(r)
    def listPluginsPaginated(request: ListPluginsRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.ListPluginsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListPluginsRequest,
      ListPluginsResponse
    ]("listPlugins", api.listPlugins)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.ListPluginsResponse.wrap)
      .provideEnvironment(r)
    def updateWorkflow(request: UpdateWorkflowRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.UpdateWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.UpdateWorkflowRequest,
      UpdateWorkflowResponse
    ]("updateWorkflow", api.updateWorkflow)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.UpdateWorkflowResponse.wrap)
      .provideEnvironment(r)
    def createWorkflowStepGroup(request: CreateWorkflowStepGroupRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest,
      CreateWorkflowStepGroupResponse
    ]("createWorkflowStepGroup", api.createWorkflowStepGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse.wrap
    ).provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getWorkflow(request: GetWorkflowRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.GetWorkflowRequest,
      GetWorkflowResponse
    ]("getWorkflow", api.getWorkflow)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.wrap)
      .provideEnvironment(r)
    def getTemplateStepGroup(request: GetTemplateStepGroupRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest,
      GetTemplateStepGroupResponse
    ]("getTemplateStepGroup", api.getTemplateStepGroup)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.wrap
      )
      .provideEnvironment(r)
    def listTemplateStepGroups(request: ListTemplateStepGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest,
      TemplateStepGroupSummary,
      ListTemplateStepGroupsPublisher
    ](
      "listTemplateStepGroups",
      api.listTemplateStepGroupsPaginator,
      _.templateStepGroupSummary()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listTemplateStepGroupsPaginated(
        request: ListTemplateStepGroupsRequest
    ): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest,
      ListTemplateStepGroupsResponse
    ]("listTemplateStepGroups", api.listTemplateStepGroups)(
      request.buildAwsValue()
    ).map(
      zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.wrap
    ).provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.ListTagsForResourceResponse.wrap
      )
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def listWorkflows(request: ListWorkflowsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest,
      MigrationWorkflowSummary,
      ListWorkflowsPublisher
    ](
      "listWorkflows",
      api.listWorkflowsPaginator,
      _.migrationWorkflowSummary()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listWorkflowsPaginated(request: ListWorkflowsRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowsRequest,
      ListWorkflowsResponse
    ]("listWorkflows", api.listWorkflows)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.wrap)
      .provideEnvironment(r)
    def listTemplateSteps(request: ListTemplateStepsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest,
      TemplateStepSummary,
      ListTemplateStepsPublisher
    ](
      "listTemplateSteps",
      api.listTemplateStepsPaginator,
      _.templateStepSummaryList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhuborchestrator.model.TemplateStepSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listTemplateStepsPaginated(request: ListTemplateStepsRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListTemplateStepsRequest,
      ListTemplateStepsResponse
    ]("listTemplateSteps", api.listTemplateSteps)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteWorkflowStepGroup(request: DeleteWorkflowStepGroupRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest,
      DeleteWorkflowStepGroupResponse
    ]("deleteWorkflowStepGroup", api.deleteWorkflowStepGroup)(
      request.buildAwsValue()
    ).map(
      zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse.wrap
    ).provideEnvironment(r)
    def deleteWorkflow(request: DeleteWorkflowRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.DeleteWorkflowRequest,
      DeleteWorkflowResponse
    ]("deleteWorkflow", api.deleteWorkflow)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.wrap)
      .provideEnvironment(r)
    def listWorkflowStepGroups(request: ListWorkflowStepGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest,
      WorkflowStepGroupSummary,
      ListWorkflowStepGroupsPublisher
    ](
      "listWorkflowStepGroups",
      api.listWorkflowStepGroupsPaginator,
      _.workflowStepGroupsSummary()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listWorkflowStepGroupsPaginated(
        request: ListWorkflowStepGroupsRequest
    ): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest,
      ListWorkflowStepGroupsResponse
    ]("listWorkflowStepGroups", api.listWorkflowStepGroups)(
      request.buildAwsValue()
    ).map(
      zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.wrap
    ).provideEnvironment(r)
    def createWorkflowStep(request: CreateWorkflowStepRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowStepRequest,
      CreateWorkflowStepResponse
    ]("createWorkflowStep", api.createWorkflowStep)(request.buildAwsValue())
      .map(
        zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.wrap
      )
      .provideEnvironment(r)
    def getTemplate(request: GetTemplateRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.GetTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateRequest,
      GetTemplateResponse
    ]("getTemplate", api.getTemplate)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.GetTemplateResponse.wrap)
      .provideEnvironment(r)
    def getTemplateStep(request: GetTemplateStepRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.GetTemplateStepRequest,
      GetTemplateStepResponse
    ]("getTemplateStep", api.getTemplateStep)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.wrap)
      .provideEnvironment(r)
    def createWorkflow(request: CreateWorkflowRequest): IO[
      AwsError,
      zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.migrationhuborchestrator.model.CreateWorkflowRequest,
      CreateWorkflowResponse
    ]("createWorkflow", api.createWorkflow)(request.buildAwsValue())
      .map(zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.wrap)
      .provideEnvironment(r)
  }
  def getWorkflowStep(request: GetWorkflowStepRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetWorkflowStepResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkflowStep(request))
  def listWorkflowSteps(request: ListWorkflowStepsRequest): ZStream[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.WorkflowStepSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflowSteps(request))
  def listWorkflowStepsPaginated(request: ListWorkflowStepsRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListWorkflowStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowStepsPaginated(request))
  def getWorkflowStepGroup(request: GetWorkflowStepGroupRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetWorkflowStepGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkflowStepGroup(request))
  def updateWorkflowStep(request: UpdateWorkflowStepRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkflowStep(request))
  def retryWorkflowStep(request: RetryWorkflowStepRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.RetryWorkflowStepResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.retryWorkflowStep(request))
  def deleteWorkflowStep(request: DeleteWorkflowStepRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkflowStep(request))
  def startWorkflow(request: StartWorkflowRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.StartWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startWorkflow(request))
  def stopWorkflow(request: StopWorkflowRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.StopWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopWorkflow(request))
  def updateWorkflowStepGroup(request: UpdateWorkflowStepGroupRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkflowStepGroup(request))
  def listTemplates(request: ListTemplatesRequest): ZStream[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.TemplateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTemplates(request))
  def listTemplatesPaginated(request: ListTemplatesRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTemplatesPaginated(request))
  def listPlugins(request: ListPluginsRequest): ZStream[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.PluginSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listPlugins(request))
  def listPluginsPaginated(request: ListPluginsRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListPluginsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPluginsPaginated(request))
  def updateWorkflow(request: UpdateWorkflowRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.UpdateWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWorkflow(request))
  def createWorkflowStepGroup(request: CreateWorkflowStepGroupRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkflowStepGroup(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getWorkflow(request: GetWorkflowRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWorkflow(request))
  def getTemplateStepGroup(request: GetTemplateStepGroupRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetTemplateStepGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplateStepGroup(request))
  def listTemplateStepGroups(request: ListTemplateStepGroupsRequest): ZStream[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.TemplateStepGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTemplateStepGroups(request))
  def listTemplateStepGroupsPaginated(
      request: ListTemplateStepGroupsRequest
  ): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListTemplateStepGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTemplateStepGroupsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listWorkflows(request: ListWorkflowsRequest): ZStream[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.MigrationWorkflowSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflows(request))
  def listWorkflowsPaginated(request: ListWorkflowsRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListWorkflowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowsPaginated(request))
  def listTemplateSteps(request: ListTemplateStepsRequest): ZStream[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.TemplateStepSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listTemplateSteps(request))
  def listTemplateStepsPaginated(request: ListTemplateStepsRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListTemplateStepsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTemplateStepsPaginated(request))
  def deleteWorkflowStepGroup(request: DeleteWorkflowStepGroupRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkflowStepGroup(request))
  def deleteWorkflow(request: DeleteWorkflowRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.DeleteWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWorkflow(request))
  def listWorkflowStepGroups(request: ListWorkflowStepGroupsRequest): ZStream[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.WorkflowStepGroupSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflowStepGroups(request))
  def listWorkflowStepGroupsPaginated(
      request: ListWorkflowStepGroupsRequest
  ): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowStepGroupsPaginated(request))
  def createWorkflowStep(request: CreateWorkflowStepRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.CreateWorkflowStepResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkflowStep(request))
  def getTemplate(request: GetTemplateRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplate(request))
  def getTemplateStep(request: GetTemplateStepRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.GetTemplateStepResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTemplateStep(request))
  def createWorkflow(request: CreateWorkflowRequest): ZIO[
    zio.aws.migrationhuborchestrator.MigrationHubOrchestrator,
    AwsError,
    zio.aws.migrationhuborchestrator.model.CreateWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkflow(request))
}
